/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.utils.IterableThreadLocal;
import cn.nukkit.utils.ThreadCache;
import cn.nukkit.utils.ZlibProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;

public final class ZlibThreadLocal
implements ZlibProvider {
    public static final IterableThreadLocal<byte[]> buf = new IterableThreadLocal<byte[]>(){

        @Override
        public byte[] init() {
            return new byte[8192];
        }
    };
    public static final IterableThreadLocal<Deflater> def = new IterableThreadLocal<Deflater>(){

        @Override
        public Deflater init() {
            return new Deflater();
        }
    };

    @Override
    public byte[] deflate(byte[][] datas, int level) throws Exception {
        Deflater deflater = ZlibThreadLocal.getDef(level);
        if (deflater == null) {
            throw new IllegalArgumentException("No deflate for level " + level + " !");
        }
        deflater.reset();
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        bos.reset();
        byte[] buffer = (byte[])buf.get();
        for (byte[] data : datas) {
            deflater.setInput(data);
            while (!deflater.needsInput()) {
                int i = deflater.deflate(buffer);
                bos.write(buffer, 0, i);
            }
        }
        deflater.finish();
        while (!deflater.finished()) {
            int i = deflater.deflate(buffer);
            bos.write(buffer, 0, i);
        }
        return bos.toByteArray();
    }

    @Override
    public byte[] deflate(byte[] data, int level) throws Exception {
        Deflater deflater = ZlibThreadLocal.getDef(level);
        if (deflater == null) {
            throw new IllegalArgumentException("No deflate for level " + level + " !");
        }
        deflater.reset();
        deflater.setInput(data);
        deflater.finish();
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        bos.reset();
        byte[] buffer = (byte[])buf.get();
        while (!deflater.finished()) {
            int i = deflater.deflate(buffer);
            bos.write(buffer, 0, i);
        }
        return bos.toByteArray();
    }

    private static Deflater getDef(int level) {
        ((Deflater)def.get()).setLevel(level);
        return (Deflater)def.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] inflate(InputStream stream) throws IOException {
        byte[] result;
        InflaterInputStream inputStream = new InflaterInputStream(stream);
        FastByteArrayOutputStream outputStream = (FastByteArrayOutputStream)ThreadCache.fbaos.get();
        outputStream.reset();
        byte[] buffer = (byte[])buf.get();
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
        }
        finally {
            result = outputStream.toByteArray();
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        return result;
    }
}

