/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBed;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBed;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;

public class BlockBed
extends BlockTransparentMeta
implements Faceable {
    public BlockBed() {
        this(0);
    }

    public BlockBed(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getResistance() {
        return 1.0;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Bed Block";
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5625;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        Block b;
        boolean isNight;
        int time = this.getLevel().getTime() % 24000;
        boolean bl = isNight = time >= 14000 && time < 23000;
        if (player != null && !isNight) {
            player.sendMessage(new TranslationContainer("tile.bed.noSleep"));
            return true;
        }
        Block blockNorth = this.north();
        Block blockSouth = this.south();
        Block blockEast = this.east();
        Block blockWest = this.west();
        if ((this.getDamage() & 8) == 8) {
            b = this;
        } else if (blockNorth.getId() == this.getId() && (blockNorth.getDamage() & 8) == 8) {
            b = blockNorth;
        } else if (blockSouth.getId() == this.getId() && (blockSouth.getDamage() & 8) == 8) {
            b = blockSouth;
        } else if (blockEast.getId() == this.getId() && (blockEast.getDamage() & 8) == 8) {
            b = blockEast;
        } else if (blockWest.getId() == this.getId() && (blockWest.getDamage() & 8) == 8) {
            b = blockWest;
        } else {
            if (player != null) {
                player.sendMessage(new TranslationContainer("tile.bed.notValid"));
            }
            return true;
        }
        if (player != null && !player.sleepOn(b)) {
            player.sendMessage(new TranslationContainer("tile.bed.occupied"));
        }
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (!down.isTransparent()) {
            Block next = this.getSide(player.getDirection());
            Block downNext = next.down();
            if (next.canBeReplaced() && !downNext.isTransparent()) {
                int meta = player.getDirection().getHorizontalIndex();
                this.getLevel().setBlock((Vector3)block, Block.get(this.getId(), meta), true, true);
                if (next instanceof BlockLiquid && ((BlockLiquid)next).usesWaterLogging()) {
                    this.getLevel().setBlock(next, 1, next, true, false);
                }
                this.getLevel().setBlock((Vector3)next, Block.get(this.getId(), meta | 8), true, true);
                this.createBlockEntity(this, item.getDamage());
                this.createBlockEntity(next, item.getDamage());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block blockNorth = this.north();
        Block blockSouth = this.south();
        Block blockEast = this.east();
        Block blockWest = this.west();
        if ((this.getDamage() & 8) == 8) {
            if (blockNorth.getId() == 26 && (blockNorth.getDamage() & 8) != 8) {
                this.getLevel().setBlock((Vector3)blockNorth, Block.get(0), true, true);
            } else if (blockSouth.getId() == 26 && (blockSouth.getDamage() & 8) != 8) {
                this.getLevel().setBlock((Vector3)blockSouth, Block.get(0), true, true);
            } else if (blockEast.getId() == 26 && (blockEast.getDamage() & 8) != 8) {
                this.getLevel().setBlock((Vector3)blockEast, Block.get(0), true, true);
            } else if (blockWest.getId() == 26 && (blockWest.getDamage() & 8) != 8) {
                this.getLevel().setBlock((Vector3)blockWest, Block.get(0), true, true);
            }
        } else if (blockNorth.getId() == this.getId() && (blockNorth.getDamage() & 8) == 8) {
            this.getLevel().setBlock((Vector3)blockNorth, Block.get(0), true, true);
        } else if (blockSouth.getId() == this.getId() && (blockSouth.getDamage() & 8) == 8) {
            this.getLevel().setBlock((Vector3)blockSouth, Block.get(0), true, true);
        } else if (blockEast.getId() == this.getId() && (blockEast.getDamage() & 8) == 8) {
            this.getLevel().setBlock((Vector3)blockEast, Block.get(0), true, true);
        } else if (blockWest.getId() == this.getId() && (blockWest.getDamage() & 8) == 8) {
            this.getLevel().setBlock((Vector3)blockWest, Block.get(0), true, true);
        }
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, false);
        return true;
    }

    private void createBlockEntity(Vector3 pos, int color) {
        CompoundTag nbt = BlockEntity.getDefaultCompound(pos, "Bed");
        nbt.putByte("color", color);
        BlockEntity.createBlockEntity("Bed", this.level.getChunk(pos.getFloorX() >> 4, pos.getFloorZ() >> 4), nbt, new Object[0]);
    }

    @Override
    public Item toItem() {
        return new ItemBed((Integer)this.getDyeColor().getWoolData());
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this)) instanceof BlockEntityBed) {
            return ((BlockEntityBed)blockEntity).getDyeColor();
        }
        return DyeColor.WHITE;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

