/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;

public abstract class BlockButton
extends BlockFlowable
implements Faceable {
    public BlockButton() {
        this(0);
    }

    public BlockButton(int meta) {
        super(meta);
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.isTransparent()) {
            return false;
        }
        this.setDamage(face.getIndex());
        this.level.setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.isActivated()) {
            return false;
        }
        this.level.scheduleUpdate(this, 30);
        this.setDamage(this.getDamage() ^ 8);
        this.level.setBlock((Vector3)this, this, true, false);
        if (this.level.getServer().isRedstoneEnabled()) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
            Location pos = this.getLocation();
            this.level.updateAroundRedstone(pos, null);
            this.level.updateAroundRedstone(((Vector3)pos).getSide(this.getFacing().getOpposite()), null);
        }
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.getSide(this.getFacing().getOpposite()).isTransparent()) {
                this.level.useBreakOn(this);
                return 1;
            }
        } else if (type == 3) {
            if (this.isActivated()) {
                this.setDamage(this.getDamage() ^ 8);
                this.level.setBlock((Vector3)this, this, true, false);
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.RANDOM_CLICK, 1.0f, 0.5f);
                if (this.level.getServer().isRedstoneEnabled()) {
                    this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
                    Location pos = this.getLocation();
                    this.level.updateAroundRedstone(pos, null);
                    this.level.updateAroundRedstone(((Vector3)pos).getSide(this.getFacing().getOpposite()), null);
                }
            }
            return 3;
        }
        return 0;
    }

    public boolean isActivated() {
        return (this.getDamage() & 8) == 8;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isActivated() ? 0 : (this.getFacing() == side ? 15 : 0);
    }

    public BlockFace getFacing() {
        int side = this.isActivated() ? this.getDamage() ^ 8 : this.getDamage();
        return BlockFace.fromIndex(side);
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isActivated()) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
        }
        return super.onBreak(item);
    }

    @Override
    public Item toItem() {
        return Item.get(this.getItemId());
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }
}

