/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityCampfire;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.CampfireInventory;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemCampfire;
import cn.nukkit.item.ItemCoal;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCampfire
extends BlockTransparentMeta
implements Faceable {
    public BlockCampfire() {
        this(0);
    }

    public BlockCampfire(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 464;
    }

    @Override
    public int getLightLevel() {
        return this.isExtinguished() ? 0 : 15;
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemCoal((Integer)0, 1 + ThreadLocalRandom.current().nextInt(1))};
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.down().getId() == 464) {
            return false;
        }
        this.setDamage(player != null ? player.getDirection().getOpposite().getHorizontalIndex() : 0);
        Block layer1 = block.getLevelBlockAtLayer(1);
        if (block instanceof BlockWater || block instanceof BlockIceFrosted || layer1 instanceof BlockWater || layer1 instanceof BlockIceFrosted) {
            this.setExtinguished(true);
            this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
        }
        this.level.setBlock((Vector3)block, this, true, false);
        this.createBlockEntity(item);
        return true;
    }

    private BlockEntityCampfire createBlockEntity(Item item) {
        CompoundTag nbt = new CompoundTag().putString("id", "Campfire").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return (BlockEntityCampfire)BlockEntity.createBlockEntity("Campfire", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!this.isExtinguished() && !entity.isSneaking()) {
            entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.FIRE, 1.0f));
        }
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block layer1;
            if (!this.isExtinguished() && ((layer1 = this.getLevelBlockAtLayer(1)) instanceof BlockWater || layer1 instanceof BlockIceFrosted)) {
                this.setExtinguished(true);
                this.level.setBlock((Vector3)this, this, true, true);
                this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        CampfireRecipe recipe;
        if (item.getId() == 0 || item.getCount() <= 0) {
            return false;
        }
        BlockEntity entity = this.level.getBlockEntity(this);
        if (!(entity instanceof BlockEntityCampfire)) {
            entity = this.createBlockEntity(Item.get(0));
        }
        boolean itemUsed = false;
        if (item.isShovel() && !this.isExtinguished()) {
            this.setExtinguished(true);
            this.level.setBlock((Vector3)this, this, true, true);
            this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
            itemUsed = true;
        } else if (item.getId() == 259) {
            item.useOn(this);
            this.setExtinguished(false);
            this.level.setBlock((Vector3)this, this, true, true);
            if (entity != null) {
                entity.scheduleUpdate();
            }
            this.level.addSound(this, Sound.FIRE_IGNITE);
            itemUsed = true;
        }
        if (entity == null) {
            return itemUsed;
        }
        BlockEntityCampfire campfire = (BlockEntityCampfire)entity;
        Item cloned = item.clone();
        cloned.setCount(1);
        CampfireInventory inventory = campfire.getInventory();
        if (inventory.canAddItem(cloned) && (recipe = this.level.getServer().getCraftingManager().matchCampfireRecipe(cloned)) != null) {
            inventory.addItem(cloned);
            item.setCount(item.getCount() - 1);
            return true;
        }
        return itemUsed;
    }

    @Override
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.4371948;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SPRUCE_BLOCK_COLOR;
    }

    public boolean isExtinguished() {
        return (this.getDamage() & 4) == 4;
    }

    public void setExtinguished(boolean extinguished) {
        this.setDamage(this.getDamage() & 3 | (extinguished ? 4 : 0));
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public void setBlockFace(BlockFace face) {
        if (face == BlockFace.UP || face == BlockFace.DOWN) {
            return;
        }
        this.setDamage(this.getDamage() & 4 | face.getHorizontalIndex());
    }

    @Override
    public String getName() {
        return "Campfire";
    }

    @Override
    public Item toItem() {
        return new ItemCampfire();
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityCampfire) {
            return ContainerInventory.calculateRedstone(((BlockEntityCampfire)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }
}

