/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockCauldronLava;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityCauldron;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.ItemCauldron;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemGlassBottle;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ItemPotionLingering;
import cn.nukkit.item.ItemPotionSplash;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;

public class BlockCauldron
extends BlockSolidMeta {
    public BlockCauldron() {
        super(0);
    }

    public BlockCauldron(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 118;
    }

    @Override
    public String getName() {
        return "Cauldron Block";
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public boolean isFull() {
        return (this.getDamage() & 6) == 6;
    }

    public boolean isEmpty() {
        return this.getDamage() == 0;
    }

    public int getFillLevel() {
        return (this.getDamage() & 6) >> 1;
    }

    public void setFillLevel(int fillLevel) {
        fillLevel = MathHelper.clamp(fillLevel, 0, 3);
        this.setDamage(fillLevel << 1);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity be = this.level.getBlockEntity(this);
        if (!(be instanceof BlockEntityCauldron)) {
            return false;
        }
        BlockEntityCauldron cauldron = (BlockEntityCauldron)be;
        switch (item.getId()) {
            case 325: {
                if (item.getDamage() == 0) {
                    if (!this.isFull() || cauldron.isCustomColor() || cauldron.hasPotion()) break;
                    ItemBucket bucket = (ItemBucket)item.clone();
                    bucket.setCount(1);
                    bucket.setDamage(8);
                    PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, this, null, this, item, bucket);
                    this.level.getServer().getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) break;
                    this.replaceBucket(item, player, ev.getItem());
                    this.setFillLevel(0);
                    this.level.setBlock((Vector3)this, this, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_TAKEWATER);
                    break;
                }
                if (item.getDamage() != 8 && item.getDamage() != 10 || this.isFull() && !cauldron.isCustomColor() && !cauldron.hasPotion() && item.getDamage() == 8) break;
                ItemBucket bucket = (ItemBucket)item.clone();
                bucket.setCount(1);
                bucket.setDamage(0);
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, this, null, this, item, bucket);
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    this.replaceBucket(item, player, ev.getItem());
                }
                if (cauldron.hasPotion()) {
                    this.clearWithFizz(cauldron);
                    break;
                }
                if (item.getDamage() == 8) {
                    this.setFillLevel(3);
                    cauldron.clearCustomColor();
                    this.level.setBlock((Vector3)this, this, true);
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_FILLWATER);
                    break;
                }
                if (this.isEmpty()) {
                    BlockCauldronLava cauldronLava = new BlockCauldronLava(14);
                    cauldronLava.setFillLevel(3);
                    this.level.setBlock((Vector3)this, cauldronLava, true, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.BUCKET_EMPTY_LAVA);
                    break;
                }
                this.clearWithFizz(cauldron);
                break;
            }
            case 351: {
                if (this.isEmpty() || cauldron.hasPotion()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    item.setCount(item.getCount() - 1);
                    player.getInventory().setItemInHand(item);
                }
                BlockColor color = new ItemDye((Integer)item.getDamage()).getDyeColor().getColor();
                if (!cauldron.isCustomColor()) {
                    cauldron.setCustomColor(color);
                } else {
                    BlockColor current = cauldron.getCustomColor();
                    BlockColor mixed = new BlockColor(current.getRed() + (color.getRed() - current.getRed()) / 2, current.getGreen() + (color.getGreen() - current.getGreen()) / 2, current.getBlue() + (color.getBlue() - current.getBlue()) / 2);
                    cauldron.setCustomColor(mixed);
                }
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_ADDDYE);
                break;
            }
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 416: {
                if (this.isEmpty() || cauldron.hasPotion()) break;
                CompoundTag compoundTag = item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag();
                compoundTag.putInt("customColor", cauldron.getCustomColor().getRGB());
                item.setCompoundTag(compoundTag);
                player.getInventory().setItemInHand(item);
                this.setFillLevel(this.getFillLevel() - 1);
                this.level.setBlock((Vector3)this, this, true, true);
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_DYEARMOR);
                break;
            }
            case 373: 
            case 438: 
            case 441: {
                if (!this.isEmpty() && (cauldron.hasPotion() ? cauldron.getPotionId() != item.getDamage() : item.getDamage() != 0)) {
                    this.clearWithFizz(cauldron);
                    this.consumePotion(item, player);
                    break;
                }
                if (this.isFull()) break;
                if (item.getDamage() != 0 && this.isEmpty()) {
                    cauldron.setPotionId(item.getDamage());
                }
                cauldron.setPotionType(item.getId() == 373 ? 0 : (item.getId() == 438 ? 1 : 2));
                cauldron.spawnToAll();
                this.setFillLevel(this.getFillLevel() + 1);
                this.level.setBlock((Vector3)this, this, true);
                this.consumePotion(item, player);
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_FILLPOTION);
                break;
            }
            case 374: {
                boolean consumeBottle;
                Item potion;
                int meta;
                if (this.isEmpty()) break;
                int n = meta = cauldron.hasPotion() ? cauldron.getPotionId() : 0;
                if (meta == 0) {
                    potion = new ItemPotion();
                } else {
                    switch (cauldron.getPotionType()) {
                        case 1: {
                            potion = new ItemPotionSplash((Integer)meta);
                            break;
                        }
                        case 2: {
                            potion = new ItemPotionLingering((Integer)meta);
                            break;
                        }
                        default: {
                            potion = new ItemPotion((Integer)meta);
                        }
                    }
                }
                this.setFillLevel(this.getFillLevel() - 1);
                if (this.isEmpty()) {
                    cauldron.setPotionId(65535);
                    cauldron.clearCustomColor();
                }
                this.level.setBlock((Vector3)this, this, true);
                boolean bl = consumeBottle = player.isSurvival() || player.isAdventure();
                if (consumeBottle && item.getCount() == 1) {
                    player.getInventory().setItemInHand(potion);
                } else if (item.getCount() > 1) {
                    if (consumeBottle) {
                        item.setCount(item.getCount() - 1);
                        player.getInventory().setItemInHand(item);
                    }
                    if (player.getInventory().canAddItem(potion)) {
                        player.getInventory().addItem(potion);
                    } else {
                        player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), potion, player.getDirectionVector().multiply(0.4));
                    }
                }
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_TAKEPOTION);
                break;
            }
            default: {
                return true;
            }
        }
        this.level.updateComparatorOutputLevel(this);
        return true;
    }

    protected void replaceBucket(Item oldBucket, Player player, Item newBucket) {
        if (player.isSurvival() || player.isAdventure()) {
            if (oldBucket.getCount() == 1) {
                player.getInventory().setItemInHand(newBucket);
            } else {
                oldBucket.setCount(oldBucket.getCount() - 1);
                if (player.getInventory().canAddItem(newBucket)) {
                    player.getInventory().addItem(newBucket);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), newBucket, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    private void consumePotion(Item item, Player player) {
        if (player.isSurvival() || player.isAdventure()) {
            if (item.getCount() == 1) {
                player.getInventory().setItemInHand(new ItemBlock(new BlockAir()));
            } else if (item.getCount() > 1) {
                item.setCount(item.getCount() - 1);
                player.getInventory().setItemInHand(item);
                ItemGlassBottle bottle = new ItemGlassBottle();
                if (player.getInventory().canAddItem(bottle)) {
                    player.getInventory().addItem(bottle);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), bottle, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    public void clearWithFizz(BlockEntityCauldron cauldron) {
        this.setFillLevel(0);
        cauldron.setPotionId(65535);
        cauldron.setSplashPotion(false);
        cauldron.clearCustomColor();
        this.level.setBlock((Vector3)this, new BlockCauldron(0), true);
        this.level.addSound(this.add(0.5, 0.0, 0.5), Sound.RANDOM_FIZZ);
        for (int i = 0; i < 8; ++i) {
            this.getLevel().addParticle(new SmokeParticle(this.add(Math.random(), 1.2, Math.random())));
        }
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        CompoundTag nbt = new CompoundTag("").putString("id", "Cauldron").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("PotionId", 65535).putByte("SplashPotion", 0);
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        BlockEntity.createBlockEntity("Cauldron", (Position)this, nbt, new Object[0]);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getTier() >= 1) {
            return new Item[]{new ItemCauldron()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemCauldron();
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getFillLevel();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

