/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityFlowerPot;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemFlowerPot;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;

public class BlockFlowerPot
extends BlockFlowable {
    public BlockFlowerPot() {
        this(0);
    }

    public BlockFlowerPot(int meta) {
        super(meta);
    }

    protected static boolean canPlaceIntoFlowerPot(int id) {
        switch (id) {
            case 6: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 81: 
            case 418: 
            case 471: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public String getName() {
        return "Flower Pot";
    }

    @Override
    public int getId() {
        return 140;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityFlowerPot flowerPot;
        if (face != BlockFace.UP) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putString("id", "FlowerPot").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("item", 0).putInt("data", 0);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        if ((flowerPot = (BlockEntityFlowerPot)BlockEntity.createBlockEntity("FlowerPot", this.getLevel().getChunk((int)block.x >> 4, (int)block.z >> 4), nbt, new Object[0])) == null) {
            return false;
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        int itemMeta;
        int blockId;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityFlowerPot)) {
            return false;
        }
        if (blockEntity.namedTag.getShort("item") != 0 || blockEntity.namedTag.getInt("mData") != 0) {
            return false;
        }
        if (!BlockFlowerPot.canPlaceIntoFlowerPot(item.getId())) {
            if (!BlockFlowerPot.canPlaceIntoFlowerPot(item.getBlock().getId())) {
                return true;
            }
            blockId = item.getBlock().getId();
            itemMeta = item.getDamage();
        } else {
            blockId = item.getId();
            itemMeta = item.getDamage();
        }
        blockEntity.namedTag.putShort("item", blockId);
        blockEntity.namedTag.putInt("data", itemMeta);
        this.setDamage(1);
        this.getLevel().setBlock((Vector3)this, this, true);
        ((BlockEntityFlowerPot)blockEntity).spawnToAll();
        if (player.isSurvival()) {
            item.setCount(item.getCount() - 1);
            player.getInventory().setItemInHand(item.getCount() > 0 ? item : Item.get(0));
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        boolean dropInside = false;
        int insideID = 0;
        int insideMeta = 0;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (blockEntity instanceof BlockEntityFlowerPot) {
            dropInside = true;
            insideID = blockEntity.namedTag.getShort("item");
            insideMeta = blockEntity.namedTag.getInt("data");
        }
        if (dropInside) {
            return new Item[]{new ItemFlowerPot(), Block.get(insideID, insideMeta).toItem()};
        }
        return new Item[]{new ItemFlowerPot()};
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemFlowerPot();
    }
}

