/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.LeavesDecayEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockLeaves
extends BlockTransparentMeta {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;

    public BlockLeaves() {
        this(0);
    }

    public BlockLeaves(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Oak Leaves", "Spruce Leaves", "Birch Leaves", "Jungle Leaves"};
        return names[this.getDamage() & 3];
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPersistent(true);
        this.getLevel().setBlock((Vector3)this, this, true);
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(18, this.getDamage() & 3);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        if (this.canDropApple() && ThreadLocalRandom.current().nextInt(200) == 0) {
            return new Item[]{Item.get(260)};
        }
        if (ThreadLocalRandom.current().nextInt(20) == 0) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return new Item[]{Item.get(280, 0, ThreadLocalRandom.current().nextInt(1, 2))};
            }
            if ((this.getDamage() & 3) != 3 || ThreadLocalRandom.current().nextInt(20) == 0) {
                return new Item[]{this.getSapling()};
            }
        }
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && !this.isPersistent() && !this.isCheckDecay()) {
            this.setCheckDecay(true);
            this.getLevel().setBlock((Vector3)this, this, false, false);
        } else if (type == 2 && this.isCheckDecay() && !this.isPersistent()) {
            this.setDamage(this.getDamage() & 3);
            LeavesDecayEvent ev = new LeavesDecayEvent(this);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled() || this.findLog(this, 7).booleanValue()) {
                this.getLevel().setBlock((Vector3)this, this, false, false);
            } else {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        }
        return 0;
    }

    private Boolean findLog(Block pos, Integer distance) {
        Block[] woodBlocks = this.getLevel().getCollisionBlocks(new SimpleAxisAlignedBB(pos.getX() - (double)distance.intValue(), pos.getY() - (double)distance.intValue(), pos.getZ() - (double)distance.intValue(), pos.getX() + (double)distance.intValue(), pos.getY() + (double)distance.intValue(), pos.getZ() + (double)distance.intValue()), true, true, block -> block.getId() == 17 || block.getId() == 162);
        return woodBlocks.length > 0;
    }

    public boolean isCheckDecay() {
        return (this.getDamage() & 8) != 0;
    }

    public void setCheckDecay(boolean checkDecay) {
        if (checkDecay) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFF7);
        }
    }

    public boolean isPersistent() {
        return (this.getDamage() & 4) != 0;
    }

    public void setPersistent(boolean persistent) {
        if (persistent) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFFB);
        }
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    protected boolean canDropApple() {
        return (this.getDamage() & 3) == 0;
    }

    protected Item getSapling() {
        return Item.get(6, this.getDamage() & 3);
    }

    @Override
    public boolean diffusesSkyLight() {
        return true;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

