/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFromToEvent;
import cn.nukkit.event.block.LiquidFlowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.Vector3;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.util.concurrent.ThreadLocalRandom;

public abstract class BlockLiquid
extends BlockTransparentMeta {
    private final byte CAN_FLOW_DOWN = 1;
    private final byte CAN_FLOW = 0;
    private final byte BLOCKED = (byte)-1;
    public int adjacentSources = 0;
    protected Vector3 flowVector = null;
    private Long2ByteMap flowCostVisited = new Long2ByteOpenHashMap();

    protected BlockLiquid(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return null;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[0];
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public double getMaxY() {
        return this.y + 1.0 - (double)this.getFluidHeightPercent();
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this;
    }

    public boolean usesWaterLogging() {
        return false;
    }

    public float getFluidHeightPercent() {
        float d = this.getDamage();
        if (d >= 8.0f) {
            d = 0.0f;
        }
        return (d + 1.0f) / 9.0f;
    }

    protected int getFlowDecay(Block block) {
        if (block.getId() != this.getId()) {
            Block layer1 = block.getLevelBlockAtLayer(1);
            if (layer1.getId() != this.getId()) {
                return -1;
            }
            return layer1.getDamage();
        }
        return block.getDamage();
    }

    protected int getEffectiveFlowDecay(Block block) {
        if (block.getId() != this.getId() && (block = block.getLevelBlockAtLayer(1)).getId() != this.getId()) {
            return -1;
        }
        int decay = block.getDamage();
        if (decay >= 8) {
            decay = 0;
        }
        return decay;
    }

    public void clearCaches() {
        this.flowVector = null;
        this.flowCostVisited.clear();
    }

    public Vector3 getFlowVector() {
        if (this.flowVector != null) {
            return this.flowVector;
        }
        Vector3 vector = new Vector3(0.0, 0.0, 0.0);
        int decay = this.getEffectiveFlowDecay(this);
        for (int j = 0; j < 4; ++j) {
            int realDecay;
            int x = (int)this.x;
            int y = (int)this.y;
            int z = (int)this.z;
            switch (j) {
                case 0: {
                    --x;
                    break;
                }
                case 1: {
                    ++x;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                default: {
                    ++z;
                }
            }
            Block sideBlock = this.level.getBlock(x, y, z);
            int blockDecay = this.getEffectiveFlowDecay(sideBlock);
            if (blockDecay < 0) {
                if (!sideBlock.canBeFlowedInto() || (blockDecay = this.getEffectiveFlowDecay(this.level.getBlock(x, y - 1, z))) < 0) continue;
                realDecay = blockDecay - (decay - 8);
                vector.x += (sideBlock.x - this.x) * (double)realDecay;
                vector.y += (sideBlock.y - this.y) * (double)realDecay;
                vector.z += (sideBlock.z - this.z) * (double)realDecay;
                continue;
            }
            realDecay = blockDecay - decay;
            vector.x += (sideBlock.x - this.x) * (double)realDecay;
            vector.y += (sideBlock.y - this.y) * (double)realDecay;
            vector.z += (sideBlock.z - this.z) * (double)realDecay;
        }
        if (!(this.getDamage() < 8 || this.canFlowInto(this.level.getBlock((int)this.x, (int)this.y, (int)this.z - 1)) && this.canFlowInto(this.level.getBlock((int)this.x, (int)this.y, (int)this.z + 1)) && this.canFlowInto(this.level.getBlock((int)this.x - 1, (int)this.y, (int)this.z)) && this.canFlowInto(this.level.getBlock((int)this.x + 1, (int)this.y, (int)this.z)) && this.canFlowInto(this.level.getBlock((int)this.x, (int)this.y + 1, (int)this.z - 1)) && this.canFlowInto(this.level.getBlock((int)this.x, (int)this.y + 1, (int)this.z + 1)) && this.canFlowInto(this.level.getBlock((int)this.x - 1, (int)this.y + 1, (int)this.z)) && this.canFlowInto(this.level.getBlock((int)this.x + 1, (int)this.y + 1, (int)this.z)))) {
            vector = vector.normalize().add(0.0, -6.0, 0.0);
        }
        this.flowVector = vector.normalize();
        return this.flowVector;
    }

    @Override
    public void addVelocityToEntity(Entity entity, Vector3 vector) {
        if (entity.canBeMovedByCurrents()) {
            Vector3 flow = this.getFlowVector();
            vector.x += flow.x;
            vector.y += flow.y;
            vector.z += flow.z;
        }
    }

    public int getFlowDecayPerBlock() {
        return 1;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            this.checkForHarden();
            if (this.usesWaterLogging() && this.layer > 0) {
                Block layer0 = this.level.getBlock((Vector3)this, 0);
                if (layer0.getId() == 0) {
                    this.level.setBlock(this, 1, Block.get(0), false, false);
                    this.level.setBlock(this, 0, this, false, false);
                } else if (layer0.getWaterloggingLevel() <= 0 || layer0.getWaterloggingLevel() == 1 && this.getDamage() > 0) {
                    this.level.setBlock(this, 1, Block.get(0), true, true);
                }
            }
            this.level.scheduleUpdate(this, this.tickRate());
            return 0;
        }
        if (type == 3) {
            int decay = this.getFlowDecay(this);
            int multiplier = this.getFlowDecayPerBlock();
            if (decay > 0) {
                int topFlowDecay;
                int smallestFlowDecay = -100;
                this.adjacentSources = 0;
                smallestFlowDecay = this.getSmallestFlowDecay(this.level.getBlock((int)this.x, (int)this.y, (int)this.z - 1), smallestFlowDecay);
                smallestFlowDecay = this.getSmallestFlowDecay(this.level.getBlock((int)this.x, (int)this.y, (int)this.z + 1), smallestFlowDecay);
                smallestFlowDecay = this.getSmallestFlowDecay(this.level.getBlock((int)this.x - 1, (int)this.y, (int)this.z), smallestFlowDecay);
                smallestFlowDecay = this.getSmallestFlowDecay(this.level.getBlock((int)this.x + 1, (int)this.y, (int)this.z), smallestFlowDecay);
                int newDecay = smallestFlowDecay + multiplier;
                if (newDecay >= 8 || smallestFlowDecay < 0) {
                    newDecay = -1;
                }
                if ((topFlowDecay = this.getFlowDecay(this.level.getBlock((int)this.x, (int)this.y + 1, (int)this.z))) >= 0) {
                    newDecay = topFlowDecay | 8;
                }
                if (this.adjacentSources >= 2 && this instanceof BlockWater) {
                    Block bottomBlock = this.level.getBlock((int)this.x, (int)this.y - 1, (int)this.z);
                    if (bottomBlock.isSolid()) {
                        newDecay = 0;
                    } else if (bottomBlock instanceof BlockWater && bottomBlock.getDamage() == 0) {
                        newDecay = 0;
                    } else if ((bottomBlock = bottomBlock.getLevelBlockAtLayer(1)) instanceof BlockWater && bottomBlock.getDamage() == 0) {
                        newDecay = 0;
                    }
                }
                if (newDecay != decay) {
                    decay = newDecay;
                    boolean decayed = decay < 0;
                    Block to = decayed ? Block.get(0) : this.getBlock(decay);
                    BlockFromToEvent event = new BlockFromToEvent(this, to);
                    this.level.getServer().getPluginManager().callEvent(event);
                    if (!event.isCancelled()) {
                        this.level.setBlock(this, this.layer, event.getTo(), true, true);
                        if (!decayed) {
                            this.level.scheduleUpdate(this, this.tickRate());
                        }
                    }
                }
            }
            if (decay >= 0) {
                int adjacentDecay;
                Block bottomBlock = this.level.getBlock((int)this.x, (int)this.y - 1, (int)this.z);
                this.flowIntoBlock(bottomBlock, decay | 8);
                if (!(decay != 0 && (!this.usesWaterLogging() ? bottomBlock.canBeFlowedInto() : bottomBlock.canWaterloggingFlowInto()) || (adjacentDecay = decay >= 8 ? 1 : decay + multiplier) >= 8)) {
                    boolean[] flags = this.getOptimalFlowDirections();
                    if (flags[0]) {
                        this.flowIntoBlock(this.level.getBlock((int)this.x - 1, (int)this.y, (int)this.z), adjacentDecay);
                    }
                    if (flags[1]) {
                        this.flowIntoBlock(this.level.getBlock((int)this.x + 1, (int)this.y, (int)this.z), adjacentDecay);
                    }
                    if (flags[2]) {
                        this.flowIntoBlock(this.level.getBlock((int)this.x, (int)this.y, (int)this.z - 1), adjacentDecay);
                    }
                    if (flags[3]) {
                        this.flowIntoBlock(this.level.getBlock((int)this.x, (int)this.y, (int)this.z + 1), adjacentDecay);
                    }
                }
                this.checkForHarden();
            }
        }
        return 0;
    }

    protected void flowIntoBlock(Block block, int newFlowDecay) {
        if (this.canFlowInto(block) && !(block instanceof BlockLiquid)) {
            if (this.usesWaterLogging()) {
                Block layer1 = block.getLevelBlockAtLayer(1);
                if (layer1 instanceof BlockLiquid) {
                    return;
                }
                if (block.getWaterloggingLevel() > 1) {
                    block = layer1;
                }
            }
            LiquidFlowEvent event = new LiquidFlowEvent(block, this, newFlowDecay);
            this.level.getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                if (block.layer == 0 && block.getId() > 0) {
                    this.level.useBreakOn(block);
                }
                this.level.setBlock(block, block.layer, this.getBlock(newFlowDecay), true, true);
                this.level.scheduleUpdate(block, this.tickRate());
            }
        }
    }

    private int calculateFlowCost(int blockX, int blockY, int blockZ, int accumulatedCost, int maxCost, int originOpposite, int lastOpposite) {
        int cost = 1000;
        for (int j = 0; j < 4; ++j) {
            int realCost;
            byte status;
            if (j == originOpposite || j == lastOpposite) continue;
            int x = blockX;
            int y = blockY;
            int z = blockZ;
            if (j == 0) {
                --x;
            } else if (j == 1) {
                ++x;
            } else if (j == 2) {
                --z;
            } else if (j == 3) {
                ++z;
            }
            long hash = Level.blockHash(x, y, z);
            if (!this.flowCostVisited.containsKey(hash)) {
                Block blockSide = this.level.getBlock(x, y, z);
                if (!this.canFlowInto(blockSide)) {
                    this.flowCostVisited.put(hash, (byte)-1);
                } else if (this.usesWaterLogging() ? this.level.getBlock(x, y - 1, z).canWaterloggingFlowInto() : this.level.getBlock(x, y - 1, z).canBeFlowedInto()) {
                    this.flowCostVisited.put(hash, (byte)1);
                } else {
                    this.flowCostVisited.put(hash, (byte)0);
                }
            }
            if ((status = this.flowCostVisited.get(hash)) == -1) continue;
            if (status == 1) {
                return accumulatedCost;
            }
            if (accumulatedCost >= maxCost || (realCost = this.calculateFlowCost(x, y, z, accumulatedCost + 1, maxCost, originOpposite, j ^ 1)) >= cost) continue;
            cost = realCost;
        }
        return cost;
    }

    @Override
    public double getHardness() {
        return 100.0;
    }

    @Override
    public double getResistance() {
        return 500.0;
    }

    private boolean[] getOptimalFlowDirections() {
        int[] flowCost = new int[]{1000, 1000, 1000, 1000};
        int maxCost = 4 / this.getFlowDecayPerBlock();
        for (int j = 0; j < 4; ++j) {
            int x = (int)this.x;
            int y = (int)this.y;
            int z = (int)this.z;
            if (j == 0) {
                --x;
            } else if (j == 1) {
                ++x;
            } else {
                z = j == 2 ? --z : ++z;
            }
            Block block = this.level.getBlock(x, y, z);
            if (!this.canFlowInto(block)) {
                this.flowCostVisited.put(Level.blockHash(x, y, z), (byte)-1);
                continue;
            }
            if (this.usesWaterLogging() ? this.level.getBlock(x, y - 1, z).canWaterloggingFlowInto() : this.level.getBlock(x, y - 1, z).canBeFlowedInto()) {
                this.flowCostVisited.put(Level.blockHash(x, y, z), (byte)1);
                maxCost = 0;
                flowCost[j] = 0;
                continue;
            }
            if (maxCost <= 0) continue;
            this.flowCostVisited.put(Level.blockHash(x, y, z), (byte)0);
            flowCost[j] = this.calculateFlowCost(x, y, z, 1, maxCost, j ^ 1, j ^ 1);
            maxCost = Math.min(maxCost, flowCost[j]);
        }
        this.flowCostVisited.clear();
        double minCost = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double d = flowCost[i];
            if (!(d < minCost)) continue;
            minCost = d;
        }
        boolean[] isOptimalFlowDirection = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            isOptimalFlowDirection[i] = (double)flowCost[i] == minCost;
        }
        return isOptimalFlowDirection;
    }

    private int getSmallestFlowDecay(Block block, int decay) {
        int blockDecay = this.getFlowDecay(block);
        if (blockDecay < 0) {
            return decay;
        }
        if (blockDecay == 0) {
            ++this.adjacentSources;
        } else if (blockDecay >= 8) {
            blockDecay = 0;
        }
        return decay >= 0 && blockDecay >= decay ? decay : blockDecay;
    }

    protected void checkForHarden() {
    }

    protected void triggerLavaMixEffects(Vector3 pos) {
        this.getLevel().addSound(pos.add(0.5, 0.5, 0.5), Sound.RANDOM_FIZZ, 1.0f, 2.6f + (ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            this.getLevel().addParticle(new SmokeParticle(pos.add(Math.random(), 1.2, Math.random())));
        }
    }

    public abstract BlockLiquid getBlock(int var1);

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
    }

    protected boolean liquidCollide(Block cause, Block result) {
        BlockFromToEvent event = new BlockFromToEvent(this, result);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.level.setBlock((Vector3)this, event.getTo(), true, true);
        this.level.setBlock(this, 1, Block.get(0), true, true);
        this.getLevel().addLevelSoundEvent(this.add(0.5, 0.5, 0.5), 27);
        return true;
    }

    protected boolean canFlowInto(Block block) {
        if (this.usesWaterLogging()) {
            if (block.canWaterloggingFlowInto()) {
                return !((block = block.getLevelBlockAtLayer(1)) instanceof BlockLiquid) || block.getDamage() != 0;
            }
            return false;
        }
        return block.canBeFlowedInto() && (!(block instanceof BlockLiquid) || block.getDamage() != 0);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(0));
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

