/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockPistonBase;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRedstone;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class BlockRedstoneWire
extends BlockFlowable {
    private boolean canProvidePower = true;
    private final Set<Vector3> blocksNeedingUpdate = new HashSet<Vector3>();

    public BlockRedstoneWire() {
        this(0);
    }

    public BlockRedstoneWire(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Redstone Wire";
    }

    @Override
    public int getId() {
        return 55;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.canBeReplaced()) {
            block = target;
        }
        if (!this.canBePlacedOn(block.down())) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled()) {
            this.getLevel().setBlock((Vector3)block, this, true, false);
            this.updateSurroundingRedstone(true);
            Location pos = this.getLocation();
            for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
                this.level.updateAroundRedstone(((Vector3)pos).getSide(blockFace), blockFace.getOpposite());
            }
            for (BlockFace blockFace : BlockFace.Plane.VERTICAL) {
                this.updateAround(((Vector3)pos).getSide(blockFace), blockFace.getOpposite());
            }
            for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
                Vector3 v = ((Vector3)pos).getSide(blockFace);
                if (this.level.getBlock(v).isNormalBlock()) {
                    this.updateAround(v.up(), BlockFace.DOWN);
                    continue;
                }
                this.updateAround(v.down(), BlockFace.UP);
            }
        } else {
            this.getLevel().setBlock((Vector3)block, this, true, true);
        }
        return true;
    }

    private void updateAround(Vector3 pos, BlockFace face) {
        if (this.level.getBlock(pos).getId() == 55) {
            this.level.updateAroundRedstone(pos, face);
            for (BlockFace side : BlockFace.values()) {
                this.level.updateAroundRedstone(pos.getSide(side), side.getOpposite());
            }
        }
    }

    private void updateSurroundingRedstone(boolean force) {
        this.calculateCurrentChanges(force);
    }

    private void calculateCurrentChanges(boolean force) {
        block9: {
            Location pos;
            block8: {
                int meta;
                pos = this.getLocation();
                int maxStrength = meta = this.getDamage();
                this.canProvidePower = false;
                int power = this.getIndirectPower();
                this.canProvidePower = true;
                if (power > 0 && power > maxStrength - 1) {
                    maxStrength = power;
                }
                int strength = 0;
                for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
                    Vector3 v = ((Vector3)pos).getSide(face);
                    if (v.getX() == this.getX() && v.getZ() == this.getZ()) continue;
                    strength = this.getMaxCurrentStrength(v, strength);
                    boolean vNormal = this.level.getBlock(v).isNormalBlock();
                    if (vNormal && !this.level.getBlock(pos.up()).isNormalBlock()) {
                        strength = this.getMaxCurrentStrength(v.up(), strength);
                        continue;
                    }
                    if (vNormal) continue;
                    strength = this.getMaxCurrentStrength(v.down(), strength);
                }
                maxStrength = strength > maxStrength ? strength - 1 : (maxStrength > 0 ? --maxStrength : 0);
                if (power > maxStrength - 1) {
                    maxStrength = power;
                } else if (power < maxStrength && strength <= maxStrength) {
                    maxStrength = Math.max(power, strength - 1);
                }
                if (meta == maxStrength) break block8;
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, meta, maxStrength));
                this.setDamage(maxStrength);
                this.level.setBlock((Vector3)this, this, false, false);
                this.level.updateAroundRedstone(this, null);
                for (BlockFace face : BlockFace.values()) {
                    this.level.updateAroundRedstone(((Vector3)pos).getSide(face), face.getOpposite());
                }
                break block9;
            }
            if (!force) break block9;
            for (BlockFace face : BlockFace.values()) {
                this.level.updateAroundRedstone(((Vector3)pos).getSide(face), face.getOpposite());
            }
        }
    }

    private int getMaxCurrentStrength(Vector3 pos, int maxStrength) {
        if (this.level.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ()) != this.getId()) {
            return maxStrength;
        }
        int strength = this.level.getBlockDataAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
        return strength > maxStrength ? strength : maxStrength;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        Location pos = this.getLocation();
        if (this.level.getServer().isRedstoneEnabled()) {
            this.updateSurroundingRedstone(false);
            for (BlockFace blockFace : BlockFace.values()) {
                this.level.updateAroundRedstone(((Vector3)pos).getSide(blockFace), null);
            }
            for (BlockFace blockFace : BlockFace.Plane.HORIZONTAL) {
                Vector3 v = ((Vector3)pos).getSide(blockFace);
                if (this.level.getBlock(v).isNormalBlock()) {
                    this.updateAround(v.up(), BlockFace.DOWN);
                    continue;
                }
                this.updateAround(v.down(), BlockFace.UP);
            }
        }
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemRedstone();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public int onUpdate(int type) {
        if (type != 1 && type != 6) {
            return 0;
        }
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return 0;
        }
        if (type == 1 && !this.canBePlacedOn(this.down())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        this.updateSurroundingRedstone(false);
        return 1;
    }

    public boolean canBePlacedOn(Block b) {
        return b.isSolid() && (!b.isTransparent() || b.getId() == 89);
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.canProvidePower ? 0 : this.getWeakPower(side);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        if (!this.canProvidePower) {
            return 0;
        }
        int power = this.getDamage();
        if (power == 0) {
            return 0;
        }
        if (side == BlockFace.UP) {
            return power;
        }
        EnumSet<BlockFace> faces = EnumSet.noneOf(BlockFace.class);
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(face)) continue;
            faces.add(face);
        }
        if (side.getAxis().isHorizontal() && faces.isEmpty()) {
            return power;
        }
        if (faces.contains((Object)side) && !faces.contains((Object)side.rotateYCCW()) && !faces.contains((Object)side.rotateY())) {
            return power;
        }
        return 0;
    }

    private boolean isPowerSourceAt(BlockFace side) {
        Location pos = this.getLocation();
        Vector3 v = ((Vector3)pos).getSide(side);
        Block block = this.level.getBlock(v);
        boolean flag = block.isNormalBlock();
        boolean flag1 = this.level.getBlock(pos.up()).isNormalBlock();
        return !flag1 && flag && BlockRedstoneWire.canConnectUpwardsTo(this.level, v.up()) || BlockRedstoneWire.canConnectTo(block, side) || !flag && BlockRedstoneWire.canConnectUpwardsTo(this.level, block.down());
    }

    protected static boolean canConnectUpwardsTo(Level level, Vector3 pos) {
        return BlockRedstoneWire.canConnectUpwardsTo(level.getBlock(pos));
    }

    protected static boolean canConnectUpwardsTo(Block block) {
        return BlockRedstoneWire.canConnectTo(block, null);
    }

    protected static boolean canConnectTo(Block block, BlockFace side) {
        if (block.getId() == 55) {
            return true;
        }
        if (BlockRedstoneDiode.isDiode(block)) {
            BlockFace face = ((BlockRedstoneDiode)block).getFacing();
            return face == side || face.getOpposite() == side;
        }
        if (block instanceof BlockPistonBase) {
            return true;
        }
        return block.isPowerSource() && side != null;
    }

    @Override
    public boolean isPowerSource() {
        return this.canProvidePower;
    }

    private int getIndirectPower() {
        int power = 0;
        Location pos = this.getLocation();
        for (BlockFace face : BlockFace.values()) {
            int blockPower = this.getIndirectPower(((Vector3)pos).getSide(face), face);
            if (blockPower >= 15) {
                return 15;
            }
            if (blockPower <= power) continue;
            power = blockPower;
        }
        return power;
    }

    private int getIndirectPower(Vector3 pos, BlockFace face) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.isNormalBlock() ? this.getStrongPower(pos) : block.getWeakPower(face);
    }

    private int getStrongPower(Vector3 pos) {
        int i = 0;
        for (BlockFace face : BlockFace.values()) {
            if ((i = Math.max(i, this.getStrongPower(pos.getSide(face), face))) < 15) continue;
            return i;
        }
        return i;
    }

    private int getStrongPower(Vector3 pos, BlockFace direction) {
        Block block = this.level.getBlock(pos);
        if (block.getId() == 55) {
            return 0;
        }
        return block.getStrongPower(direction);
    }
}

