/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWoodBark;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockWood
extends BlockSolidMeta {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;

    public BlockWood() {
        this(0);
    }

    public BlockWood(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Oak Wood", "Spruce Wood", "Birch Wood", "Jungle Wood"};
        return names[this.getDamage() & 3];
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 10;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        short[] faces = new short[]{0, 0, 8, 8, 4, 4};
        this.setDamage(this.getDamage() & 3 | faces[face.getIndex()]);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    protected int getStrippedId() {
        int[] strippedIds = new int[]{265, 260, 261, 262};
        return strippedIds[this.getDamage() & 3];
    }

    protected int getStrippedDamage() {
        return this.getDamage() >> 2;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isAxe()) {
            Block strippedBlock = Block.get(this.getStrippedId(), this.getStrippedDamage());
            item.useOn(this);
            this.level.setBlock((Vector3)this, strippedBlock, true, true);
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        if ((this.getDamage() & 0xC) == 12) {
            return new ItemBlock(new BlockWoodBark(), (Integer)(this.getDamage() & 3));
        }
        return new ItemBlock(this, (Integer)(this.getDamage() & 3));
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            default: {
                return BlockColor.WOOD_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.SPRUCE_BLOCK_COLOR;
            }
            case 2: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 3: 
        }
        return BlockColor.DIRT_BLOCK_COLOR;
    }
}

