/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnableContainer;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.ChestInventory;
import cn.nukkit.inventory.DoubleChestInventory;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.HashSet;

public class BlockEntityChest
extends BlockEntitySpawnableContainer
implements BlockEntityNameable {
    protected DoubleChestInventory doubleInventory = null;

    public BlockEntityChest(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new ChestInventory(this);
        super.initBlockEntity();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.unpair();
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getRealInventory());
            }
            super.close();
        }
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.getBlock().getId();
        return blockID == 54 || blockID == 146;
    }

    @Override
    public int getSize() {
        return 27;
    }

    @Override
    public BaseInventory getInventory() {
        if (this.doubleInventory == null && this.isPaired()) {
            this.checkPairing();
        }
        return this.doubleInventory != null ? this.doubleInventory : this.inventory;
    }

    public ChestInventory getRealInventory() {
        return (ChestInventory)this.inventory;
    }

    protected void checkPairing() {
        BlockEntityChest pair = this.getPair();
        if (pair != null) {
            if (!pair.isPaired()) {
                pair.createPair(this);
                pair.checkPairing();
            }
            if (pair.doubleInventory != null) {
                this.doubleInventory = pair.doubleInventory;
            } else if (this.doubleInventory == null) {
                this.doubleInventory = pair.x + (double)((int)pair.z << 15) > this.x + (double)((int)this.z << 15) ? new DoubleChestInventory(pair, this) : new DoubleChestInventory(this, pair);
            }
        } else if (this.level.isChunkLoaded(this.namedTag.getInt("pairx") >> 4, this.namedTag.getInt("pairz") >> 4)) {
            this.doubleInventory = null;
            this.namedTag.remove("pairx");
            this.namedTag.remove("pairz");
        }
    }

    public boolean isPaired() {
        return this.namedTag.contains("pairx") && this.namedTag.contains("pairz");
    }

    public BlockEntityChest getPair() {
        BlockEntity blockEntity;
        if (this.isPaired() && (blockEntity = this.getLevel().getBlockEntityIfLoaded(new Vector3(this.namedTag.getInt("pairx"), this.y, this.namedTag.getInt("pairz")))) instanceof BlockEntityChest) {
            return (BlockEntityChest)blockEntity;
        }
        return null;
    }

    public boolean pairWith(BlockEntityChest chest) {
        if (this.isPaired() || chest.isPaired() || this.getBlock().getId() != chest.getBlock().getId()) {
            return false;
        }
        this.createPair(chest);
        chest.spawnToAll();
        this.spawnToAll();
        this.checkPairing();
        return true;
    }

    public void createPair(BlockEntityChest chest) {
        this.namedTag.putInt("pairx", (int)chest.x);
        this.namedTag.putInt("pairz", (int)chest.z);
        chest.namedTag.putInt("pairx", (int)this.x);
        chest.namedTag.putInt("pairz", (int)this.z);
    }

    public boolean unpair() {
        if (!this.isPaired()) {
            return false;
        }
        BlockEntityChest chest = this.getPair();
        this.doubleInventory = null;
        this.namedTag.remove("pairx");
        this.namedTag.remove("pairz");
        this.spawnToAll();
        if (chest != null) {
            chest.namedTag.remove("pairx");
            chest.namedTag.remove("pairz");
            chest.doubleInventory = null;
            chest.checkPairing();
            chest.spawnToAll();
        }
        this.checkPairing();
        return true;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = this.isPaired() ? new CompoundTag().putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putInt("pairx", this.namedTag.getInt("pairx")).putInt("pairz", this.namedTag.getInt("pairz")) : new CompoundTag().putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Chest";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals("")) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }
}

