/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.inventory.FurnaceBurnEvent;
import cn.nukkit.event.inventory.FurnaceSmeltEvent;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.SmeltingRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.ContainerSetDataPacket;
import java.util.HashSet;

public class BlockEntityFurnace
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected FurnaceInventory inventory;
    protected int burnTime = 0;
    protected int burnDuration = 0;
    protected int cookTime = 0;
    protected int maxTime = 0;

    public BlockEntityFurnace(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    protected InventoryType getInventoryType() {
        return InventoryType.FURNACE;
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new FurnaceInventory(this, this.getInventoryType());
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.inventory.setItem(i, this.getItem(i));
        }
        this.burnTime = !this.namedTag.contains("BurnTime") || this.namedTag.getShort("BurnTime") < 0 ? 0 : this.namedTag.getShort("BurnTime");
        this.cookTime = !this.namedTag.contains("CookTime") || this.namedTag.getShort("CookTime") < 0 || this.namedTag.getShort("BurnTime") == 0 && this.namedTag.getShort("CookTime") > 0 ? 0 : this.namedTag.getShort("CookTime");
        if (!this.namedTag.contains("MaxTime")) {
            this.maxTime = this.burnTime;
            this.burnDuration = 0;
        } else {
            this.maxTime = this.namedTag.getShort("MaxTime");
        }
        if (this.namedTag.contains("BurnTicks")) {
            this.burnDuration = this.namedTag.getShort("BurnTicks");
            this.namedTag.remove("BurnTicks");
        }
        if (this.burnTime > 0) {
            this.scheduleUpdate();
        }
        super.initBlockEntity();
    }

    protected String getFurnaceName() {
        return "Furnace";
    }

    protected String getClientName() {
        return "Furnace";
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : this.getFurnaceName();
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals("")) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    @Override
    public void saveNBT() {
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putShort("CookTime", this.cookTime);
        this.namedTag.putShort("BurnTime", this.burnTime);
        this.namedTag.putShort("BurnDuration", this.burnDuration);
        this.namedTag.putShort("MaxTime", this.maxTime);
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.getBlock().getId();
        return blockID == this.getIdleBlockId() || blockID == this.getBurningBlockId();
    }

    @Override
    public int getSize() {
        return 3;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public FurnaceInventory getInventory() {
        return this.inventory;
    }

    protected int getIdleBlockId() {
        return 61;
    }

    protected int getBurningBlockId() {
        return 62;
    }

    protected void setBurning(boolean burning) {
        if (burning) {
            if (this.getBlock().getId() == this.getIdleBlockId()) {
                this.getLevel().setBlock((Vector3)this, Block.get(this.getBurningBlockId(), this.getBlock().getDamage()), true);
            }
        } else if (this.getBlock().getId() == this.getBurningBlockId()) {
            this.getLevel().setBlock((Vector3)this, Block.get(this.getIdleBlockId(), this.getBlock().getDamage()), true);
        }
    }

    protected void checkFuel(Item fuel) {
        FurnaceBurnEvent ev = new FurnaceBurnEvent(this, fuel, fuel.getFuelTime() == null ? (short)0 : fuel.getFuelTime());
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.maxTime = (int)Math.ceil((float)ev.getBurnTime() / (float)this.getSpeedMultiplier());
        this.burnTime = (int)Math.ceil((float)ev.getBurnTime() / (float)this.getSpeedMultiplier());
        this.burnDuration = 0;
        this.setBurning(true);
        if (this.burnTime > 0 && ev.isBurning()) {
            fuel.setCount(fuel.getCount() - 1);
            if (fuel.getCount() == 0) {
                if (fuel.getId() == 325 && fuel.getDamage() == 10) {
                    fuel.setDamage(0);
                    fuel.setCount(1);
                } else {
                    fuel = new ItemBlock(Block.get(0), (Integer)0, 0);
                }
            }
            this.inventory.setFuel(fuel);
        }
    }

    protected SmeltingRecipe matchRecipe(Item raw) {
        return this.server.getCraftingManager().matchFurnaceRecipe(raw);
    }

    protected int getSpeedMultiplier() {
        return 1;
    }

    @Override
    public boolean onUpdate() {
        boolean canSmelt;
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean ret = false;
        Item fuel = this.inventory.getFuel();
        Item raw = this.inventory.getSmelting();
        Item product = this.inventory.getResult();
        SmeltingRecipe smelt = this.matchRecipe(raw);
        boolean bl = canSmelt = smelt != null && raw.getCount() > 0 && (smelt.getResult().equals(product, true) && product.getCount() < product.getMaxStackSize() || product.getId() == 0);
        if (this.burnTime <= 0 && canSmelt && fuel.getFuelTime() != null && fuel.getCount() > 0) {
            this.checkFuel(fuel);
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            int readyAt = 200 / this.getSpeedMultiplier();
            this.burnDuration = (int)Math.ceil((float)this.burnTime / (float)this.maxTime * (float)readyAt);
            if (smelt != null && canSmelt) {
                ++this.cookTime;
                if (this.cookTime >= readyAt) {
                    product = Item.get(smelt.getResult().getId(), smelt.getResult().getDamage(), product.getCount() + 1);
                    FurnaceSmeltEvent ev = new FurnaceSmeltEvent(this, raw, product);
                    this.server.getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.inventory.setResult(ev.getResult());
                        raw.setCount(raw.getCount() - 1);
                        if (raw.getCount() == 0) {
                            raw = new ItemBlock(Block.get(0), (Integer)0, 0);
                        }
                        this.inventory.setSmelting(raw);
                    }
                    this.cookTime -= readyAt;
                }
            } else if (this.burnTime <= 0) {
                this.burnTime = 0;
                this.cookTime = 0;
                this.burnDuration = 0;
            } else {
                this.cookTime = 0;
            }
            ret = true;
        } else {
            this.setBurning(false);
            this.burnTime = 0;
            this.cookTime = 0;
            this.burnDuration = 0;
        }
        for (Player player : this.getInventory().getViewers()) {
            int windowId = player.getWindowId(this.getInventory());
            if (windowId <= 0) continue;
            ContainerSetDataPacket pk = new ContainerSetDataPacket();
            pk.windowId = windowId;
            pk.property = 0;
            pk.value = this.cookTime;
            player.batchDataPacket(pk);
            pk = new ContainerSetDataPacket();
            pk.windowId = windowId;
            pk.property = 1;
            pk.value = this.burnDuration;
            player.batchDataPacket(pk);
        }
        this.lastUpdate = System.currentTimeMillis();
        this.timing.stopTiming();
        return ret;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", this.getClientName()).putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("BurnDuration", this.burnDuration).putShort("BurnTime", this.burnTime).putShort("CookTime", this.cookTime);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getBurnDuration() {
        return this.burnDuration;
    }

    public void setBurnDuration(int burnDuration) {
        this.burnDuration = burnDuration;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }
}

