/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.command.CommandSender;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.level.Level;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.ThreadCache;

public class GarbageCollectorCommand
extends VanillaCommand {
    public GarbageCollectorCommand(String name) {
        super(name, "%nukkit.command.gc.description", "%nukkit.command.gc.usage");
        this.setPermission("nukkit.command.gc");
        this.commandParameters.clear();
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        int chunksCollected = 0;
        int entitiesCollected = 0;
        int tilesCollected = 0;
        long memory = Runtime.getRuntime().freeMemory();
        for (Level level : sender.getServer().getLevels().values()) {
            int chunksCount = level.getChunks().size();
            int entitiesCount = level.getEntities().length;
            int tilesCount = level.getBlockEntities().size();
            level.doChunkGarbageCollection();
            level.unloadChunks(true);
            chunksCollected += chunksCount - level.getChunks().size();
            entitiesCollected += entitiesCount - level.getEntities().length;
            tilesCollected += tilesCount - level.getBlockEntities().size();
        }
        ThreadCache.clean();
        System.gc();
        long freedMemory = Runtime.getRuntime().freeMemory() - memory;
        sender.sendMessage((Object)((Object)TextFormat.GREEN) + "---- " + (Object)((Object)TextFormat.WHITE) + "Garbage collection result" + (Object)((Object)TextFormat.GREEN) + " ----");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Chunks: " + (Object)((Object)TextFormat.RED) + chunksCollected);
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Entities: " + (Object)((Object)TextFormat.RED) + entitiesCollected);
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Block Entities: " + (Object)((Object)TextFormat.RED) + tilesCollected);
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Memory freed: " + (Object)((Object)TextFormat.RED) + NukkitMath.round((double)freedMemory / 1024.0 / 1024.0, 2) + " MB");
        return true;
    }
}

