/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.item.Item;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;

public class GiveCommand
extends VanillaCommand {
    public GiveCommand(String name) {
        super(name, "%nukkit.command.give.description", "%nukkit.command.give.usage");
        this.setPermission("nukkit.command.give");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{new CommandParameter("player", CommandParamType.TARGET, false), new CommandParameter("item", false, "itemType"), new CommandParameter("amount", CommandParamType.INT, true), new CommandParameter("meta", CommandParamType.INT, true), new CommandParameter("tags...", CommandParamType.RAWTEXT, true)});
        this.commandParameters.put("toPlayerById", new CommandParameter[]{new CommandParameter("player", CommandParamType.TARGET, false), new CommandParameter("item ID", CommandParamType.INT, false), new CommandParameter("amount", CommandParamType.INT, true), new CommandParameter("tags...", CommandParamType.RAWTEXT, true)});
        this.commandParameters.put("toPlayerByIdMeta", new CommandParameter[]{new CommandParameter("player", CommandParamType.TARGET, false), new CommandParameter("item ID:meta", CommandParamType.RAWTEXT, false), new CommandParameter("amount", CommandParamType.INT, true), new CommandParameter("tags...", CommandParamType.RAWTEXT, true)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        Item item;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        Player player = sender.getServer().getPlayer(args[0]);
        try {
            item = Item.fromString(args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        try {
            item.setCount(Integer.parseInt(args[2]));
        }
        catch (Exception e) {
            item.setCount(item.getMaxStackSize());
        }
        if (player != null) {
            if (item.getId() == 0) {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.give.item.notFound", args[1]));
                return true;
            }
        } else {
            sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.player.notFound"));
            return true;
        }
        player.getInventory().addItem(item.clone());
        Command.broadcastCommandMessage(sender, new TranslationContainer("%commands.give.success", item.getName() + " (" + item.getId() + ":" + item.getDamage() + ")", String.valueOf(item.getCount()), player.getName()));
        return true;
    }
}

