/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;

public class SayCommand
extends VanillaCommand {
    public SayCommand(String name) {
        super(name, "%nukkit.command.say.description", "%commands.say.usage");
        this.setPermission("nukkit.command.say");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{new CommandParameter("message")});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        String senderString = sender instanceof Player ? ((Player)sender).getDisplayName() : (sender instanceof ConsoleCommandSender ? "Server" : sender.getName());
        String msg = "";
        for (String arg : args) {
            msg = msg + arg + " ";
        }
        if (msg.length() > 0) {
            msg = msg.substring(0, msg.length() - 1);
        }
        sender.getServer().broadcastMessage(new TranslationContainer((Object)((Object)TextFormat.LIGHT_PURPLE) + "%chat.type.announcement", senderString, (Object)((Object)TextFormat.LIGHT_PURPLE) + msg));
        return true;
    }
}

