/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.vehicle.VehicleDamageByEntityEvent;
import cn.nukkit.event.vehicle.VehicleDamageEvent;
import cn.nukkit.event.vehicle.VehicleDestroyByEntityEvent;
import cn.nukkit.event.vehicle.VehicleDestroyEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;

public abstract class EntityVehicle
extends Entity
implements EntityRideable,
EntityInteractable {
    protected boolean rollingDirection = true;

    public EntityVehicle(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    public int getRollingAmplitude() {
        return this.getDataPropertyInt(11);
    }

    public void setRollingAmplitude(int time) {
        this.setDataProperty(new IntEntityData(11, time));
    }

    public int getRollingDirection() {
        return this.getDataPropertyInt(12);
    }

    public void setRollingDirection(int direction) {
        this.setDataProperty(new IntEntityData(12, direction));
    }

    public int getDamage() {
        return this.getDataPropertyInt(1);
    }

    public void setDamage(int damage) {
        this.setDataProperty(new IntEntityData(1, damage));
    }

    @Override
    public String getInteractButtonText() {
        return "Mount";
    }

    @Override
    public boolean canDoInteraction() {
        return this.passengers.isEmpty();
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.y < -16.0) {
            this.kill();
        }
        this.updateMovement();
        return true;
    }

    protected boolean performHurtAnimation() {
        this.setRollingAmplitude(9);
        this.setRollingDirection(this.rollingDirection ? 1 : -1);
        this.rollingDirection = !this.rollingDirection;
        return true;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        Entity damagingEntity;
        boolean instantKill = false;
        if (source instanceof EntityDamageByEntityEvent) {
            damagingEntity = ((EntityDamageByEntityEvent)source).getDamager();
            VehicleDamageByEntityEvent byEvent = new VehicleDamageByEntityEvent(this, damagingEntity, source.getFinalDamage());
            this.getServer().getPluginManager().callEvent(byEvent);
            if (byEvent.isCancelled()) {
                return false;
            }
            instantKill = damagingEntity instanceof Player && ((Player)damagingEntity).isCreative();
        } else {
            VehicleDamageEvent damageEvent = new VehicleDamageEvent(this, source.getFinalDamage());
            this.getServer().getPluginManager().callEvent(damageEvent);
            if (damageEvent.isCancelled()) {
                return false;
            }
        }
        if (instantKill || this.getHealth() - source.getFinalDamage() < 1.0f) {
            if (source instanceof EntityDamageByEntityEvent) {
                damagingEntity = ((EntityDamageByEntityEvent)source).getDamager();
                VehicleDestroyByEntityEvent byDestroyEvent = new VehicleDestroyByEntityEvent(this, damagingEntity);
                this.getServer().getPluginManager().callEvent(byDestroyEvent);
                if (byDestroyEvent.isCancelled()) {
                    return false;
                }
            } else {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(this);
                this.getServer().getPluginManager().callEvent(destroyEvent);
                if (destroyEvent.isCancelled()) {
                    return false;
                }
            }
        }
        if (instantKill) {
            source.setDamage(1000.0f);
        }
        return super.attack(source);
    }
}

