/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityEnderPearl
extends EntityProjectile {
    public static final int NETWORK_ID = 87;

    @Override
    public int getNetworkId() {
        return 87;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    protected float getGravity() {
        return 0.03f;
    }

    @Override
    protected float getDrag() {
        return 0.01f;
    }

    public EntityEnderPearl(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityEnderPearl(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.isCollided && this.shootingEntity instanceof Player) {
            boolean portal = false;
            for (Block collided : this.getCollisionBlocks()) {
                if (collided.getId() != 90) continue;
                portal = true;
            }
            if (!portal) {
                this.teleport();
            }
        }
        if (this.age > 1200 || this.isCollided) {
            this.kill();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (this.shootingEntity instanceof Player) {
            this.teleport();
        }
        super.onCollideWithEntity(entity);
    }

    private void teleport() {
        this.shootingEntity.teleport(new Vector3((double)NukkitMath.floorDouble(this.x) + 0.5, this.y, (double)NukkitMath.floorDouble(this.z) + 0.5), PlayerTeleportEvent.TeleportCause.ENDER_PEARL);
        if ((((Player)this.shootingEntity).getGamemode() & 1) == 0) {
            this.shootingEntity.attack(new EntityDamageByEntityEvent((Entity)this, this.shootingEntity, EntityDamageEvent.DamageCause.PROJECTILE, 5.0f, 0.0f));
        }
        this.level.addSound(this, Sound.MOB_ENDERMEN_PORTAL);
    }
}

