/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;

public class CraftingTransferMaterialAction
extends InventoryAction {
    private int slot;

    public CraftingTransferMaterialAction(Item sourceItem, Item targetItem, int slot) {
        super(sourceItem, targetItem);
        this.slot = slot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onAddToTransaction(InventoryTransaction transaction) {
        if (!(transaction instanceof CraftingTransaction)) throw new RuntimeException(this.getClass().getName() + " can only be added to CraftingTransactions");
        if (this.sourceItem.isNull()) {
            ((CraftingTransaction)transaction).setInput(this.slot, this.targetItem);
            return;
        } else {
            if (!this.targetItem.isNull()) throw new RuntimeException("Invalid " + this.getClass().getName() + ", either source or target item must be air, got source: " + this.sourceItem + ", target: " + this.targetItem);
            ((CraftingTransaction)transaction).setExtraOutput(this.slot, this.sourceItem);
        }
    }

    @Override
    public boolean isValid(Player source) {
        return true;
    }

    @Override
    public boolean execute(Player source) {
        return true;
    }

    @Override
    public void onExecuteSuccess(Player $source) {
    }

    @Override
    public void onExecuteFail(Player source) {
    }
}

