/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.event.player.PlayerItemConsumeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;

public class ItemBucket
extends Item {
    public ItemBucket() {
        this((Integer)0, 1);
    }

    public ItemBucket(Integer meta) {
        this(meta, 1);
    }

    public ItemBucket(Integer meta, int count) {
        super(325, meta, count, ItemBucket.getName(meta));
    }

    protected static String getName(int meta) {
        switch (meta) {
            case 1: {
                return "Milk";
            }
            case 2: {
                return "Bucket of Cod";
            }
            case 3: {
                return "Bucket of Salmon";
            }
            case 4: {
                return "Bucket of Tropical Fish";
            }
            case 5: {
                return "Bucket of Pufferfish";
            }
            case 8: {
                return "Water Bucket";
            }
            case 10: {
                return "Lava Bucket";
            }
        }
        return "Bucket";
    }

    public static int getDamageByTarget(int target) {
        switch (target) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                return 8;
            }
            case 10: 
            case 11: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.meta == 0 ? 16 : 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        Block targetBlock = Block.get(ItemBucket.getDamageByTarget(this.meta));
        if (targetBlock instanceof BlockAir) {
            if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                target = target.getLevelBlockAtLayer(1);
            }
            if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                target = block;
            }
            if (!(target instanceof BlockLiquid) || target.getDamage() != 0) {
                target = block.getLevelBlockAtLayer(1);
            }
            if (target instanceof BlockLiquid && target.getDamage() == 0) {
                Item result = Item.get(325, ItemBucket.getDamageByTarget(target.getId()), 1);
                PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, block, face, target, this, result);
                player.getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    player.getLevel().setBlock(target, target.layer, Block.get(0), true, true);
                    for (BlockFace side : BlockFace.Plane.HORIZONTAL) {
                        Block b = target.getSideAtLayer(0, side);
                        if (b.getId() != 9) continue;
                        level.setBlock(b, Block.get(8));
                    }
                    if (player.isSurvival()) {
                        Item clone = this.clone();
                        clone.setCount(this.getCount() - 1);
                        player.getInventory().setItemInHand(clone);
                        player.getInventory().addItem(ev.getItem());
                    }
                    if (target instanceof BlockLava) {
                        level.addLevelSoundEvent(block, 91);
                    } else {
                        level.addLevelSoundEvent(block, 90);
                    }
                    return true;
                }
                player.getInventory().sendContents(player);
            }
        } else if (targetBlock instanceof BlockLiquid) {
            boolean canBeFlowedInto;
            Item result = Item.get(325, 0, 1);
            boolean usesWaterlogging = ((BlockLiquid)targetBlock).usesWaterLogging();
            Block placementBlock = usesWaterlogging ? (block.getId() == 418 ? block : (target.getWaterloggingLevel() > 0 ? target.getLevelBlockAtLayer(1) : (block.getWaterloggingLevel() > 0 ? block.getLevelBlockAtLayer(1) : block))) : block;
            PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, placementBlock, face, target, this, result);
            player.getServer().getPluginManager().callEvent(ev);
            boolean bl = canBeFlowedInto = placementBlock.canBeFlowedInto() || placementBlock.getId() == 418;
            if (usesWaterlogging) {
                ev.setCancelled(placementBlock.getWaterloggingLevel() <= 0 && !canBeFlowedInto);
            } else {
                ev.setCancelled(!canBeFlowedInto);
            }
            if (player.getLevel().getDimension() == 1 && this.getDamage() != 10) {
                ev.setCancelled(true);
            }
            player.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                player.getLevel().setBlock(placementBlock, placementBlock.layer, targetBlock, true, true);
                if (player.isSurvival()) {
                    Item clone = this.clone();
                    clone.setCount(this.getCount() - 1);
                    player.getInventory().setItemInHand(clone);
                    player.getInventory().addItem(ev.getItem());
                }
                if (this.getDamage() == 10) {
                    level.addLevelSoundEvent(block, 93);
                } else {
                    level.addLevelSoundEvent(block, 92);
                }
                return true;
            }
            player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{block.getLevelBlockAtLayer(1)}, 11, 1);
            player.getInventory().sendContents(player);
        }
        return false;
    }

    @Override
    public boolean onClickAir(Player player, Vector3 directionVector) {
        return this.getDamage() == 1;
    }

    @Override
    public boolean onUse(Player player, int ticksUsed) {
        PlayerItemConsumeEvent consumeEvent = new PlayerItemConsumeEvent(player, this);
        player.getServer().getPluginManager().callEvent(consumeEvent);
        if (consumeEvent.isCancelled()) {
            player.getInventory().sendContents(player);
            return false;
        }
        if (player.isSurvival()) {
            --this.count;
            player.getInventory().setItemInHand(this);
            player.getInventory().addItem(new ItemBucket());
        }
        player.removeAllEffects();
        return true;
    }
}

