/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.block.Block;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.NibbleArray;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.ThreadCache;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Zlib;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ChunkSection
implements cn.nukkit.level.format.ChunkSection {
    public static final int STREAM_STORAGE_VERSION = 8;
    public static final int SAVE_STORAGE_VERSION = 7;
    private final int y;
    private final List<BlockStorage> storage = new ArrayList<BlockStorage>(1);
    protected byte[] blockLight;
    protected byte[] skyLight;
    protected byte[] compressedLight;
    protected boolean hasBlockLight;
    protected boolean hasSkyLight;

    private ChunkSection(int y, List<BlockStorage> storage, byte[] blockLight, byte[] skyLight, byte[] compressedLight, boolean hasBlockLight, boolean hasSkyLight) {
        this.y = y;
        this.storage.addAll(storage);
        this.skyLight = skyLight;
        this.compressedLight = compressedLight;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
    }

    public ChunkSection(int y) {
        this.y = y;
        this.hasBlockLight = false;
        this.hasSkyLight = false;
        this.storage.add(new BlockStorage());
    }

    public ChunkSection(CompoundTag nbt) {
        ListTag<CompoundTag> storageList;
        this.y = nbt.getByte("Y");
        this.storage.add(new BlockStorage());
        int version = nbt.getByte("Version");
        if (version == 7 || version == 8) {
            storageList = nbt.getList("Storage", CompoundTag.class);
        } else if (version == 0 || version == 1) {
            storageList = new ListTag("Storage");
            storageList.add(nbt);
        } else {
            throw new ChunkException("Unsupported chunk section version: " + version);
        }
        for (int i = 0; i < storageList.size(); ++i) {
            byte[] dataBytes;
            CompoundTag storageTag = storageList.get(i);
            byte[] blocks = storageTag.getByteArray("Blocks");
            boolean hasBlockIds = false;
            if (blocks.length == 0) {
                blocks = new byte[4096];
            } else {
                hasBlockIds = true;
            }
            byte[] blocksExtra = storageTag.getByteArray("BlocksExtra");
            if (blocksExtra.length == 0) {
                blocksExtra = new byte[blocks.length];
            }
            if ((dataBytes = storageTag.getByteArray("Data")).length == 0) {
                dataBytes = new byte[2048];
            } else {
                hasBlockIds = true;
            }
            NibbleArray data = new NibbleArray(dataBytes);
            byte[] dataExtraBytes = storageTag.getByteArray("DataExtra");
            if (dataExtraBytes.length == 0) {
                dataExtraBytes = new byte[dataBytes.length];
            }
            NibbleArray dataExtra = new NibbleArray(dataExtraBytes);
            if (!hasBlockIds) continue;
            BlockStorage storage = this.getOrSetStorage(i);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int index = ChunkSection.getAnvilIndex(x, y, z);
                        storage.setBlockId(x, y, z, blocks[index] & 0xFF | (blocksExtra[index] & 0xFF) << 8);
                        storage.setBlockData(x, y, z, data.get(index) & 0xF | (dataExtra.get(index) & 0xF) << 4);
                    }
                }
            }
        }
        this.blockLight = nbt.getByteArray("BlockLight");
        this.skyLight = nbt.getByteArray("SkyLight");
    }

    private static int getAnvilIndex(int x, int y, int z) {
        return (y << 8) + (z << 4) + x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.getBlockId(x, y, z, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockId(int x, int y, int z, int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            BlockStorage storage = this.getStorageIfExists(layer);
            return storage != null ? storage.getBlockId(x, y, z) : 0;
        }
    }

    @Override
    public void setBlockId(int x, int y, int z, int id) {
        this.setBlockId(x, y, z, 0, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockId(int x, int y, int z, int layer, int id) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            this.getOrSetStorage(layer).setBlockId(x, y, z, id);
        }
    }

    @Override
    public boolean setFullBlockId(int x, int y, int z, int fullId) {
        this.setFullBlockId(x, y, z, 0, fullId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFullBlockId(int x, int y, int z, int layer, int fullId) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            this.getOrSetStorage(layer).setFullBlock(x, y, z, fullId);
        }
        return true;
    }

    @Override
    public int getBlockData(int x, int y, int z) {
        return this.getBlockData(x, y, z, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockData(int x, int y, int z, int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            BlockStorage storage = this.getStorageIfExists(layer);
            return storage != null ? storage.getBlockData(x, y, z) : 0;
        }
    }

    @Override
    public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(x, y, z, 0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlockData(int x, int y, int z, int layer, int data) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            this.getOrSetStorage(layer).setBlockData(x, y, z, data);
        }
    }

    @Override
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFullBlock(int x, int y, int z, int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            BlockStorage storage = this.getStorageIfExists(layer);
            return storage != null ? storage.getFullBlock(x, y, z) : 0;
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlockAtLayer(x, y, z, 0, blockId, 0);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId) {
        return this.setBlockAtLayer(x, y, z, layer, blockId, 0);
    }

    @Override
    public Block getAndSetBlock(int x, int y, int z, Block block) {
        return this.getAndSetBlock(x, y, z, 0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getAndSetBlock(int x, int y, int z, int layer, Block block) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            int fullId = this.getOrSetStorage(layer).getAndSetFullBlock(x, y, z, block.getFullId());
            return Block.fullList[fullId].clone();
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, 0, blockId, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta) {
        int newFullId = (blockId << 6) + meta;
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            int previousFullId = this.getOrSetStorage(layer).getAndSetFullBlock(x, y, z, newFullId);
            return newFullId != previousFullId;
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        if (this.skyLight == null) {
            if (!this.hasSkyLight) {
                return 0;
            }
            if (this.compressedLight == null) {
                return 15;
            }
        }
        this.skyLight = this.getSkyLightArray();
        int sl = this.skyLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return sl & 0xF;
        }
        return sl >> 4;
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        if (this.skyLight == null) {
            if (this.hasSkyLight && this.compressedLight != null) {
                this.skyLight = this.getSkyLightArray();
            } else {
                if (level == (this.hasSkyLight ? 15 : 0)) {
                    return;
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.skyLight[i] & 0xFF;
        this.skyLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.blockLight == null && !this.hasBlockLight) {
            return 0;
        }
        this.blockLight = this.getLightArray();
        int l = this.blockLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return l & 0xF;
        }
        return l >> 4;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        if (this.blockLight == null) {
            if (this.hasBlockLight) {
                this.blockLight = this.getLightArray();
            } else {
                if (level == 0) {
                    return;
                }
                this.blockLight = new byte[2048];
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.blockLight[i] & 0xFF;
        this.blockLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIdExtraArray(int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            byte[] anvil = new byte[4096];
            BlockStorage storage = this.getStorageIfExists(layer);
            if (storage != null && storage.hasBlockIdExtras()) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            int index = ChunkSection.getAnvilIndex(x, y, z);
                            anvil[index] = (byte)storage.getBlockIdExtra(x, y, z);
                        }
                    }
                }
            }
            return anvil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIdArray(int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            byte[] anvil = new byte[4096];
            BlockStorage storage = this.getStorageIfExists(layer);
            if (storage != null && storage.hasBlockIds()) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            int index = ChunkSection.getAnvilIndex(x, y, z);
                            anvil[index] = (byte)storage.getBlockIdBase(x, y, z);
                        }
                    }
                }
            }
            return anvil;
        }
    }

    @Override
    public byte[] getIdArray() {
        return this.getIdArray(0);
    }

    @Override
    public byte[] getDataArray() {
        return this.getDataArray(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDataArray(int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            NibbleArray anvil = new NibbleArray(4096);
            BlockStorage storage = this.getStorageIfExists(layer);
            if (storage != null && storage.hasBlockIds()) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            int index = ChunkSection.getAnvilIndex(x, y, z);
                            anvil.set(index, (byte)storage.getBlockDataBase(x, y, z));
                        }
                    }
                }
            }
            return anvil.getData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDataExtraArray(int layer) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            NibbleArray anvil = new NibbleArray(4096);
            BlockStorage storage = this.getStorageIfExists(layer);
            if (storage != null && storage.hasBlockDataExtras()) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            int index = ChunkSection.getAnvilIndex(x, y, z);
                            anvil.set(index, (byte)storage.getBlockDataExtra(x, y, z));
                        }
                    }
                }
            }
            return anvil.getData();
        }
    }

    @Override
    public byte[] getSkyLightArray() {
        if (this.skyLight != null) {
            return this.skyLight;
        }
        if (this.hasSkyLight) {
            if (this.compressedLight != null) {
                this.inflate();
                return this.skyLight;
            }
            return EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
        }
        return EmptyChunkSection.EMPTY_LIGHT_ARR;
    }

    private void inflate() {
        try {
            if (this.compressedLight != null && this.compressedLight.length != 0) {
                byte[] inflated = Zlib.inflate(this.compressedLight);
                this.blockLight = Arrays.copyOfRange(inflated, 0, 2048);
                if (inflated.length > 2048) {
                    this.skyLight = Arrays.copyOfRange(inflated, 2048, 4096);
                } else {
                    this.skyLight = new byte[2048];
                    if (this.hasSkyLight) {
                        Arrays.fill(this.skyLight, (byte)-1);
                    }
                }
                this.compressedLight = null;
            } else {
                this.blockLight = new byte[2048];
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getLightArray() {
        if (this.blockLight != null) {
            return this.blockLight;
        }
        if (this.hasBlockLight) {
            this.inflate();
            return this.blockLight;
        }
        return EmptyChunkSection.EMPTY_LIGHT_ARR;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private byte[] toXZY(char[] raw) {
        int i;
        byte[] buffer = (byte[])ThreadCache.byteCache6144.get();
        for (i = 0; i < 4096; ++i) {
            buffer[i] = (byte)(raw[i] >> 4);
        }
        i = 0;
        int j = 4096;
        while (i < 4096) {
            buffer[j] = (byte)((raw[i + 1] & 0xF) << 4 | raw[i] & 0xF);
            i += 2;
            ++j;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(BinaryStream stream) {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            stream.putByte((byte)8);
            stream.putByte((byte)this.storage.size());
            for (BlockStorage blockStorage : this.storage) {
                if (blockStorage == null) {
                    blockStorage = new BlockStorage();
                }
                int[] ids = blockStorage.getBlockIdsExtended();
                int[] data = blockStorage.getBlockDataExtended();
                int[] blockStates = new int[ids.length];
                Int2IntOpenHashMap runtime2palette = new Int2IntOpenHashMap();
                ArrayList palette2runtime = new ArrayList();
                AtomicInteger nextPaletteId = new AtomicInteger(0);
                AtomicInteger maxRuntimeId = new AtomicInteger(0);
                for (int i = 0; i < blockStates.length; ++i) {
                    int paletteId;
                    int runtimeId = GlobalBlockPalette.getOrCreateRuntimeId(ids[i], data[i]);
                    blockStates[i] = paletteId = runtime2palette.computeIfAbsent(runtimeId, rid -> {
                        int pid = nextPaletteId.getAndIncrement();
                        palette2runtime.add(rid);
                        if (maxRuntimeId.get() < rid) {
                            maxRuntimeId.set(rid);
                        }
                        return pid;
                    });
                }
                int bitsPerBlock = 16;
                stream.putByte((byte)(1 | bitsPerBlock << 1));
                for (int blockState : blockStates) {
                    stream.putLShort(blockState);
                }
                stream.putVarInt(palette2runtime.size());
                Object object = palette2runtime.iterator();
                while (object.hasNext()) {
                    Integer runtimeId = (Integer)object.next();
                    stream.putVarInt(runtimeId);
                }
            }
        }
    }

    @Override
    public byte[] getBytes() {
        BinaryStream stream = new BinaryStream();
        this.writeToStream(stream);
        return stream.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundTag toNBT() {
        CompoundTag s = new CompoundTag();
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            this.compressStorageLayers();
            s.putByte("Y", this.getY());
            int version = 7;
            ListTag<CompoundTag> storageList = new ListTag<CompoundTag>("Storage");
            for (int layer = 0; layer < this.storage.size(); ++layer) {
                CompoundTag storageTag;
                BlockStorage storage = this.getStorageIfExists(layer);
                if (storage == null) {
                    storage = new BlockStorage();
                }
                if (layer == 0 && this.storage.size() == 1) {
                    storageTag = s;
                    version = !storage.hasBlockDataExtras() && !storage.hasBlockIdExtras() ? 0 : 1;
                } else {
                    storageTag = new CompoundTag();
                }
                if (version == 0 || storage.hasBlockIds()) {
                    storageTag.putByteArray("Blocks", this.getIdArray(layer));
                    storageTag.putByteArray("Data", this.getDataArray(layer));
                    if (storage.hasBlockIdExtras()) {
                        storageTag.putByteArray("BlocksExtra", this.getIdExtraArray(layer));
                    }
                    if (storage.hasBlockDataExtras()) {
                        storageTag.putByteArray("DataExtra", this.getDataExtraArray(layer));
                    }
                }
                if (version < 7) continue;
                storageList.add(storageTag);
            }
            s.putByte("Version", version);
            if (version >= 7) {
                s.putList(storageList);
            }
        }
        s.putByteArray("BlockLight", this.getLightArray());
        s.putByteArray("SkyLight", this.getSkyLightArray());
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressStorageLayers() {
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            for (int i = this.storage.size() - 1; i > 0; --i) {
                BlockStorage storage = this.storage.get(i);
                if (storage == null) {
                    this.storage.remove(i);
                    continue;
                }
                if (storage.hasBlockIds()) {
                    storage.recheckBlocks();
                    if (storage.hasBlockIds()) break;
                    this.storage.remove(i);
                    continue;
                }
                this.storage.remove(i);
            }
        }
    }

    public boolean compress() {
        if (this.blockLight != null) {
            byte[] arr2;
            byte[] arr1 = this.blockLight;
            boolean bl = this.hasBlockLight = !Utils.isByteArrayEmpty(arr1);
            if (this.skyLight != null) {
                arr2 = this.skyLight;
                this.hasSkyLight = !Utils.isByteArrayEmpty(arr2);
            } else if (this.hasSkyLight) {
                arr2 = EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
            } else {
                arr2 = EmptyChunkSection.EMPTY_LIGHT_ARR;
                this.hasSkyLight = false;
            }
            this.blockLight = null;
            this.skyLight = null;
            byte[] toDeflate = null;
            if (this.hasBlockLight && this.hasSkyLight && arr2 != EmptyChunkSection.EMPTY_SKY_LIGHT_ARR) {
                toDeflate = Binary.appendBytes(arr1, (byte[][])new byte[][]{arr2});
            } else if (this.hasBlockLight) {
                toDeflate = arr1;
            }
            if (toDeflate != null) {
                try {
                    this.compressedLight = Zlib.deflate(toDeflate, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockStorage getOrSetStorage(int layer) {
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Negative storage layer");
        Preconditions.checkArgument((layer <= this.getMaximumLayer() ? 1 : 0) != 0, (String)"Only layer 0 to %d are supported", (int)this.getMaximumLayer());
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            BlockStorage blockStorage;
            BlockStorage blockStorage2 = blockStorage = layer < this.storage.size() ? this.storage.get(layer) : null;
            if (blockStorage == null) {
                blockStorage = new BlockStorage();
                for (int i = this.storage.size(); i < layer; ++i) {
                    this.storage.add(i, null);
                }
                if (layer == this.storage.size()) {
                    this.storage.add(layer, blockStorage);
                } else {
                    this.storage.set(layer, blockStorage);
                }
            }
            return blockStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockStorage getStorageIfExists(int layer) {
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Negative storage layer");
        if (layer > this.getMaximumLayer()) {
            return null;
        }
        List<BlockStorage> list = this.storage;
        synchronized (list) {
            return layer < this.storage.size() ? this.storage.get(layer) : null;
        }
    }

    @Override
    public ChunkSection copy() {
        BlockStorage[] storageCopy = new BlockStorage[Math.min(this.storage.size(), this.getMaximumLayer() + 1)];
        for (int i = 0; i < storageCopy.length; ++i) {
            BlockStorage blockStorage = this.getStorageIfExists(i);
            storageCopy[i] = blockStorage != null ? blockStorage.copy() : null;
        }
        return new ChunkSection(this.y, Arrays.asList(storageCopy), this.blockLight == null ? null : (byte[])this.blockLight.clone(), this.skyLight == null ? null : (byte[])this.skyLight.clone(), this.compressedLight == null ? null : (byte[])this.compressedLight.clone(), this.hasBlockLight, this.hasSkyLight);
    }

    @Override
    public int getMaximumLayer() {
        return 1;
    }
}

