/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.math;

import java.util.Random;

public class MathHelper {
    private static float[] a = new float[65536];

    private MathHelper() {
    }

    public static float sqrt(float paramFloat) {
        return (float)Math.sqrt(paramFloat);
    }

    public static float sin(float paramFloat) {
        return a[(int)(paramFloat * 10430.378f) & 0xFFFF];
    }

    public static float cos(float paramFloat) {
        return a[(int)(paramFloat * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float sin(double paramFloat) {
        return a[(int)(paramFloat * 10430.3779296875) & 0xFFFF];
    }

    public static float cos(double paramFloat) {
        return a[(int)(paramFloat * 10430.3779296875 + 16384.0) & 0xFFFF];
    }

    public static int floor(double d0) {
        int i = (int)d0;
        return d0 < (double)i ? i - 1 : i;
    }

    public static long floor_double_long(double d) {
        long l = (long)d;
        return d >= (double)l ? l : l - 1L;
    }

    public static int floor_float_int(float f) {
        int i = (int)f;
        return f >= (float)i ? i : i - 1;
    }

    public static int abs(int number) {
        if (number > 0) {
            return number;
        }
        return -number;
    }

    public static int log2(int bits) {
        return 32 - Integer.numberOfLeadingZeros(bits);
    }

    public static int getRandomNumberInRange(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    public static double max(double first, double second, double third, double fourth) {
        if (first > second && first > third && first > fourth) {
            return first;
        }
        if (second > third && second > fourth) {
            return second;
        }
        if (third > fourth) {
            return third;
        }
        return fourth;
    }

    public static int ceil(float floatNumber) {
        int truncated = (int)floatNumber;
        return floatNumber > (float)truncated ? truncated + 1 : truncated;
    }

    public static int clamp(int check, int min, int max) {
        return check > max ? max : (check < min ? min : check);
    }

    public static float clamp(float num, float min, float max) {
        return num > max ? max : (num < min ? min : num);
    }

    public static double denormalizeClamp(double lowerBnd, double upperBnd, double slide) {
        return slide < 0.0 ? lowerBnd : (slide > 1.0 ? upperBnd : lowerBnd + (upperBnd - lowerBnd) * slide);
    }

    public static float denormalizeClamp(float lowerBnd, float upperBnd, float slide) {
        return slide < 0.0f ? lowerBnd : (slide > 1.0f ? upperBnd : lowerBnd + (upperBnd - lowerBnd) * slide);
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.a[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

