/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.EntityLink;
import cn.nukkit.utils.Binary;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;

public class AddEntityPacket
extends DataPacket {
    public static final byte NETWORK_ID = 13;
    public static ImmutableMap<Integer, String> LEGACY_IDS = ImmutableMap.builder().put((Object)51, (Object)"minecraft:npc").put((Object)63, (Object)"minecraft:player").put((Object)48, (Object)"minecraft:wither_skeleton").put((Object)47, (Object)"minecraft:husk").put((Object)46, (Object)"minecraft:stray").put((Object)45, (Object)"minecraft:witch").put((Object)44, (Object)"minecraft:zombie_villager").put((Object)43, (Object)"minecraft:blaze").put((Object)42, (Object)"minecraft:magma_cube").put((Object)41, (Object)"minecraft:ghast").put((Object)40, (Object)"minecraft:cave_spider").put((Object)39, (Object)"minecraft:silverfish").put((Object)38, (Object)"minecraft:enderman").put((Object)37, (Object)"minecraft:slime").put((Object)36, (Object)"minecraft:zombie_pigman").put((Object)35, (Object)"minecraft:spider").put((Object)34, (Object)"minecraft:skeleton").put((Object)33, (Object)"minecraft:creeper").put((Object)32, (Object)"minecraft:zombie").put((Object)26, (Object)"minecraft:skeleton_horse").put((Object)25, (Object)"minecraft:mule").put((Object)24, (Object)"minecraft:donkey").put((Object)31, (Object)"minecraft:dolphin").put((Object)111, (Object)"minecraft:tropicalfish").put((Object)14, (Object)"minecraft:wolf").put((Object)17, (Object)"minecraft:squid").put((Object)110, (Object)"minecraft:drowned").put((Object)13, (Object)"minecraft:sheep").put((Object)16, (Object)"minecraft:mooshroom").put((Object)113, (Object)"minecraft:panda").put((Object)109, (Object)"minecraft:salmon").put((Object)12, (Object)"minecraft:pig").put((Object)15, (Object)"minecraft:villager").put((Object)112, (Object)"minecraft:cod").put((Object)108, (Object)"minecraft:pufferfish").put((Object)11, (Object)"minecraft:cow").put((Object)10, (Object)"minecraft:chicken").put((Object)107, (Object)"minecraft:balloon").put((Object)29, (Object)"minecraft:llama").put((Object)20, (Object)"minecraft:iron_golem").put((Object)18, (Object)"minecraft:rabbit").put((Object)21, (Object)"minecraft:snow_golem").put((Object)19, (Object)"minecraft:bat").put((Object)22, (Object)"minecraft:ocelot").put((Object)23, (Object)"minecraft:horse").put((Object)75, (Object)"minecraft:cat").put((Object)28, (Object)"minecraft:polar_bear").put((Object)27, (Object)"minecraft:zombie_horse").put((Object)74, (Object)"minecraft:turtle").put((Object)30, (Object)"minecraft:parrot").put((Object)49, (Object)"minecraft:guardian").put((Object)50, (Object)"minecraft:elder_guardian").put((Object)57, (Object)"minecraft:vindicator").put((Object)52, (Object)"minecraft:wither").put((Object)53, (Object)"minecraft:ender_dragon").put((Object)54, (Object)"minecraft:shulker").put((Object)55, (Object)"minecraft:endermite").put((Object)84, (Object)"minecraft:minecart").put((Object)96, (Object)"minecraft:hopper_minecart").put((Object)97, (Object)"minecraft:tnt_minecart").put((Object)98, (Object)"minecraft:chest_minecart").put((Object)100, (Object)"minecraft:command_block_minecart").put((Object)61, (Object)"minecraft:armor_stand").put((Object)64, (Object)"minecraft:item").put((Object)65, (Object)"minecraft:tnt").put((Object)66, (Object)"minecraft:falling_block").put((Object)68, (Object)"minecraft:xp_bottle").put((Object)69, (Object)"minecraft:xp_orb").put((Object)70, (Object)"minecraft:eye_of_ender_signal").put((Object)71, (Object)"minecraft:ender_crystal").put((Object)76, (Object)"minecraft:shulker_bullet").put((Object)77, (Object)"minecraft:fishing_hook").put((Object)79, (Object)"minecraft:dragon_fireball").put((Object)80, (Object)"minecraft:arrow").put((Object)81, (Object)"minecraft:snowball").put((Object)82, (Object)"minecraft:egg").put((Object)83, (Object)"minecraft:painting").put((Object)73, (Object)"minecraft:thrown_trident").put((Object)85, (Object)"minecraft:fireball").put((Object)86, (Object)"minecraft:splash_potion").put((Object)87, (Object)"minecraft:ender_pearl").put((Object)88, (Object)"minecraft:leash_knot").put((Object)89, (Object)"minecraft:wither_skull").put((Object)91, (Object)"minecraft:wither_skull_dangerous").put((Object)90, (Object)"minecraft:boat").put((Object)93, (Object)"minecraft:lightning_bolt").put((Object)94, (Object)"minecraft:small_fireball").put((Object)102, (Object)"minecraft:llama_spit").put((Object)95, (Object)"minecraft:area_effect_cloud").put((Object)101, (Object)"minecraft:lingering_potion").put((Object)72, (Object)"minecraft:fireworks_rocket").put((Object)103, (Object)"minecraft:evocation_fang").put((Object)104, (Object)"minecraft:evocation_illager").put((Object)105, (Object)"minecraft:vex").put((Object)56, (Object)"minecraft:agent").put((Object)106, (Object)"minecraft:ice_bomb").put((Object)58, (Object)"minecraft:phantom").put((Object)62, (Object)"minecraft:tripod_camera").put((Object)114, (Object)"minecraft:pillager").put((Object)118, (Object)"minecraft:wandering_trader").put((Object)59, (Object)"minecraft:ravager").put((Object)115, (Object)"minecraft:villager_v2").put((Object)116, (Object)"minecraft:zombie_villager_v2").put((Object)121, (Object)"minecraft:fox").put((Object)122, (Object)"minecraft:bee").build();
    public long entityUniqueId;
    public long entityRuntimeId;
    public int type;
    public String id;
    public float x;
    public float y;
    public float z;
    public float speedX = 0.0f;
    public float speedY = 0.0f;
    public float speedZ = 0.0f;
    public float yaw;
    public float pitch;
    public float headYaw;
    public EntityMetadata metadata = new EntityMetadata();
    public Attribute[] attributes = new Attribute[0];
    public EntityLink[] links = new EntityLink[0];

    @Override
    public byte pid() {
        return 13;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityUniqueId(this.entityUniqueId);
        this.putEntityRuntimeId(this.entityRuntimeId);
        if (this.id == null) {
            this.id = (String)LEGACY_IDS.get((Object)this.type);
        }
        this.putString(this.id);
        this.putVector3f(this.x, this.y, this.z);
        this.putVector3f(this.speedX, this.speedY, this.speedZ);
        this.putLFloat(this.pitch);
        this.putLFloat(this.yaw);
        this.putLFloat(this.headYaw);
        this.putAttributeList(this.attributes);
        this.put(Binary.writeMetadata(this.metadata));
        this.putUnsignedVarInt(this.links.length);
        for (EntityLink link : this.links) {
            this.putEntityLink(link);
        }
    }

    public String toString() {
        return "AddEntityPacket(entityUniqueId=" + this.entityUniqueId + ", entityRuntimeId=" + this.entityRuntimeId + ", type=" + this.type + ", id=" + this.id + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", speedX=" + this.speedX + ", speedY=" + this.speedY + ", speedZ=" + this.speedZ + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", headYaw=" + this.headYaw + ", metadata=" + this.metadata + ", attributes=" + Arrays.deepToString(this.attributes) + ", links=" + Arrays.deepToString(this.links) + ")";
    }
}

