/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWood;
import cn.nukkit.event.block.LeavesDecayEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Hash;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class BlockLeaves
extends BlockTransparentMeta {
    private static final BlockFace[] VISIT_ORDER = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN, BlockFace.UP};
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;

    public BlockLeaves() {
        this(0);
    }

    public BlockLeaves(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Oak Leaves", "Spruce Leaves", "Birch Leaves", "Jungle Leaves"};
        return names[this.getDamage() & 3];
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPersistent(true);
        this.getLevel().setBlock((Vector3)this, this, true);
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(18, this.getDamage() & 3);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        if (this.canDropApple() && ThreadLocalRandom.current().nextInt(200) == 0) {
            return new Item[]{Item.get(260)};
        }
        if (ThreadLocalRandom.current().nextInt(20) == 0) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return new Item[]{Item.get(280, 0, ThreadLocalRandom.current().nextInt(1, 2))};
            }
            if ((this.getDamage() & 3) != 3 || ThreadLocalRandom.current().nextInt(20) == 0) {
                return new Item[]{this.getSapling()};
            }
        }
        return new Item[0];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            if (this.isCheckDecay()) {
                if (this.isPersistent() || this.findLog(this, 7, null).booleanValue()) {
                    this.setCheckDecay(false);
                    this.getLevel().setBlock((Vector3)this, this, false, false);
                } else {
                    LeavesDecayEvent ev = new LeavesDecayEvent(this);
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().useBreakOn(this);
                    }
                }
                return type;
            }
        } else if (type == 1 || type == 3) {
            if (!this.isCheckDecay()) {
                this.setCheckDecay(true);
                this.getLevel().setBlock((Vector3)this, this, false, false);
            }
            for (BlockFace side : BlockFace.values()) {
                BlockLeaves otherLeave;
                Block other = this.getSide(side);
                if (!(other instanceof BlockLeaves) || (otherLeave = (BlockLeaves)other).isCheckDecay()) continue;
                this.getLevel().scheduleUpdate(otherLeave, 2);
            }
            return type;
        }
        return type;
    }

    private Boolean findLog(Block current, int distance, Long2LongMap visited) {
        if (visited == null) {
            visited = new Long2LongOpenHashMap();
            visited.defaultReturnValue(-1L);
        }
        if (current instanceof BlockWood) {
            return true;
        }
        if (distance == 0 || !(current instanceof BlockLeaves)) {
            return false;
        }
        long hash = BlockLeaves.hashBlock(current);
        if (visited.get(hash) >= (long)distance) {
            return false;
        }
        visited.put(hash, (long)distance);
        for (BlockFace face : VISIT_ORDER) {
            if (!this.findLog(current.getSide(face), distance - 1, visited).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckDecay() {
        return (this.getDamage() & 8) != 0;
    }

    public void setCheckDecay(boolean checkDecay) {
        if (checkDecay) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFF7);
        }
    }

    public boolean isPersistent() {
        return (this.getDamage() & 4) != 0;
    }

    public void setPersistent(boolean persistent) {
        if (persistent) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() & 0xFFFFFFFB);
        }
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    protected boolean canDropApple() {
        return (this.getDamage() & 3) == 0;
    }

    protected Item getSapling() {
        return Item.get(6, this.getDamage() & 3);
    }

    @Override
    public boolean diffusesSkyLight() {
        return true;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Deprecated
    private static long hashBlock(Vector3 blockPos) {
        return Hash.hashBlock(blockPos.getFloorX(), blockPos.getFloorY(), blockPos.getFloorZ());
    }
}

