/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTorch;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockRedstoneTorch
extends BlockTorch {
    public BlockRedstoneTorch() {
        this(0);
    }

    public BlockRedstoneTorch(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Redstone Torch";
    }

    @Override
    public int getId() {
        return 76;
    }

    @Override
    public int getLightLevel() {
        return 7;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (!super.place(item, block, target, face, fx, fy, fz, player)) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled()) {
            if (!this.checkState()) {
                BlockFace facing = this.getBlockFace().getOpposite();
                Location pos = this.getLocation();
                for (BlockFace side : BlockFace.values()) {
                    if (facing == side) continue;
                    this.level.updateAroundRedstone(((Vector3)pos).getSide(side), null);
                }
            }
            this.checkState();
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.getBlockFace() != side ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return side == BlockFace.DOWN ? this.getWeakPower(side) : 0;
    }

    @Override
    public boolean onBreak(Item item) {
        super.onBreak(item);
        Location pos = this.getLocation();
        BlockFace face = this.getBlockFace().getOpposite();
        if (this.level.getServer().isRedstoneEnabled()) {
            for (BlockFace side : BlockFace.values()) {
                if (side == face) continue;
                this.level.updateAroundRedstone(((Vector3)pos).getSide(side), null);
            }
        }
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (super.onUpdate(type) == 0) {
            if (!this.level.getServer().isRedstoneEnabled()) {
                return 0;
            }
            if (type == 1 || type == 6) {
                this.level.scheduleUpdate(this, this.tickRate());
            } else if (type == 3) {
                RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return 0;
                }
                if (this.checkState()) {
                    return 1;
                }
            }
        }
        return 0;
    }

    private boolean checkState() {
        if (this.isPoweredFromSide()) {
            BlockFace face = this.getBlockFace().getOpposite();
            Location pos = this.getLocation();
            this.level.setBlock((Vector3)pos, Block.get(75, this.getDamage()), false, true);
            for (BlockFace side : BlockFace.values()) {
                if (side == face) continue;
                this.level.updateAroundRedstone(((Vector3)pos).getSide(side), null);
            }
            return true;
        }
        return false;
    }

    protected boolean isPoweredFromSide() {
        BlockFace face = this.getBlockFace().getOpposite();
        return this.level.isSidePowered(this.getLocation().getSide(face), face);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }
}

