/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.level.generator.object.BasicGenerator;
import cn.nukkit.level.generator.object.tree.NewJungleTree;
import cn.nukkit.level.generator.object.tree.ObjectDarkOakTree;
import cn.nukkit.level.generator.object.tree.ObjectJungleBigTree;
import cn.nukkit.level.generator.object.tree.ObjectSavannaTree;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSapling
extends BlockFlowable {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int BIRCH_TALL = 10;
    public static final int JUNGLE = 3;
    public static final int ACACIA = 4;
    public static final int DARK_OAK = 5;

    public BlockSapling() {
        this(0);
    }

    public BlockSapling(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Oak Sapling", "Spruce Sapling", "Birch Sapling", "Jungle Sapling", "Acacia Sapling", "Dark Oak Sapling", "", ""};
        return names[this.getDamage() & 7];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (down.getId() == 2 || down.getId() == 3 || down.getId() == 60 || down.getId() == 243) {
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            if ((double)ThreadLocalRandom.current().nextFloat() >= 0.45) {
                return true;
            }
            this.grow();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.down().isTransparent()) return 1;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 1;
        if (ThreadLocalRandom.current().nextInt(1, 8) != 1 || this.getLevel().getFullLight(this.add(0.0, 1.0, 0.0)) < 9) return 2;
        if ((this.getDamage() & 8) == 8) {
            this.grow();
            return 1;
        } else {
            this.setDamage(this.getDamage() | 8);
            this.getLevel().setBlock((Vector3)this, this, true);
            return 2;
        }
    }

    private void grow() {
        int x;
        TreeGenerator generator = null;
        boolean bigTree = false;
        int z = 0;
        switch (this.getDamage() & 7) {
            case 3: {
                block5: for (x = 0; x >= -1; --x) {
                    while (z >= -1) {
                        if (this.findSaplings(x, z, 3)) {
                            generator = new ObjectJungleBigTree(10, 20, Block.get(17, 3), Block.get(18, 3));
                            bigTree = true;
                            break block5;
                        }
                        --z;
                    }
                }
                if (bigTree) break;
                x = 0;
                z = 0;
                generator = new NewJungleTree(4, 7);
                break;
            }
            case 4: {
                generator = new ObjectSavannaTree();
                break;
            }
            case 5: {
                block7: while (x >= -1) {
                    while (z >= -1) {
                        if (this.findSaplings(x, z, 5)) {
                            generator = new ObjectDarkOakTree();
                            bigTree = true;
                            break block7;
                        }
                        --z;
                    }
                    --x;
                }
                if (bigTree) break;
                return;
            }
            default: {
                ObjectTree.growTree(this.level, this.getFloorX(), this.getFloorY(), this.getFloorZ(), new NukkitRandom(), this.getDamage() & 7);
                return;
            }
        }
        if (bigTree) {
            this.level.setBlock((Vector3)this.add(x, 0.0, z), BlockSapling.get(0), true, false);
            this.level.setBlock((Vector3)this.add(x + 1, 0.0, z), BlockSapling.get(0), true, false);
            this.level.setBlock((Vector3)this.add(x, 0.0, z + 1), BlockSapling.get(0), true, false);
            this.level.setBlock((Vector3)this.add(x + 1, 0.0, z + 1), BlockSapling.get(0), true, false);
        } else {
            this.level.setBlock((Vector3)this, BlockSapling.get(0), true, false);
        }
        if (!((BasicGenerator)generator).generate(this.level, new NukkitRandom(), this.add(x, 0.0, z))) {
            if (bigTree) {
                this.level.setBlock((Vector3)this.add(x, 0.0, z), this, true, false);
                this.level.setBlock((Vector3)this.add(x + 1, 0.0, z), this, true, false);
                this.level.setBlock((Vector3)this.add(x, 0.0, z + 1), this, true, false);
                this.level.setBlock((Vector3)this.add(x + 1, 0.0, z + 1), this, true, false);
            } else {
                this.level.setBlock((Vector3)this, this, true, false);
            }
        }
    }

    private boolean findSaplings(int x, int z, int type) {
        return this.isSameType(this.add(x, 0.0, z), type) && this.isSameType(this.add(x + 1, 0.0, z), type) && this.isSameType(this.add(x, 0.0, z + 1), type) && this.isSameType(this.add(x + 1, 0.0, z + 1), type);
    }

    public boolean isSameType(Vector3 pos, int type) {
        Block block = this.level.getBlock(pos);
        return block.getId() == this.getId() && (block.getDamage() & 7) == (type & 7);
    }

    @Override
    public Item toItem() {
        return Item.get(6, this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

