/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;

public abstract class BlockSlab
extends BlockTransparentMeta {
    protected final int doubleSlab;

    public BlockSlab(int meta, int doubleSlab) {
        super(meta);
        this.doubleSlab = doubleSlab;
    }

    @Override
    public double getMinY() {
        return (this.getDamage() & 8) > 0 ? this.y + 0.5 : this.y;
    }

    @Override
    public double getMaxY() {
        return (this.getDamage() & 8) > 0 ? this.y + 1.0 : this.y + 0.5;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return this.getToolType() < 4 ? 30.0 : 15.0;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(this.getDamage() & 7);
        if (face == BlockFace.DOWN) {
            if (target instanceof BlockSlab && (target.getDamage() & 8) == 8 && (target.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock((Vector3)target, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            if (block instanceof BlockSlab && (block.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock((Vector3)block, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            this.setDamage(this.getDamage() | 8);
        } else if (face == BlockFace.UP) {
            if (target instanceof BlockSlab && (target.getDamage() & 8) == 0 && (target.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock((Vector3)target, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
            if (block instanceof BlockSlab && (block.getDamage() & 7) == (this.getDamage() & 7)) {
                this.getLevel().setBlock((Vector3)block, Block.get(this.doubleSlab, this.getDamage()), true);
                return true;
            }
        } else {
            if (block instanceof BlockSlab) {
                if ((block.getDamage() & 7) == (this.getDamage() & 7)) {
                    this.getLevel().setBlock((Vector3)block, Block.get(this.doubleSlab, this.getDamage()), true);
                    return true;
                }
                return false;
            }
            if (fy > 0.5) {
                this.setDamage(this.getDamage() | 8);
            }
        }
        if (block instanceof BlockSlab && (target.getDamage() & 7) != (this.getDamage() & 7)) {
            return false;
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }
}

