/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSlab;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.utils.BlockColor;

public class BlockSlabRedSandstone
extends BlockSlab {
    public static final int RED_SANDSTONE = 0;
    public static final int PURPUR = 1;
    public static final int PRISMARINE = 2;
    public static final int PRISMARINE_BRICKS = 3;
    public static final int DARK_PRISMARINE = 4;
    public static final int MOSSY_COBBLESTONE = 5;
    public static final int SMOOTH_SANDSTONE = 6;
    public static final int RED_NETHER_BRICK = 7;

    public BlockSlabRedSandstone() {
        this(0);
    }

    public BlockSlabRedSandstone(int meta) {
        super(meta, 181);
    }

    @Override
    public int getId() {
        return 182;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Red Sandstone", "Purpur", "Prismarine", "Prismarine Bricks", "Dark Prismarine", "Mossy Cobblestone", "Smooth Sandstone", "Red Nether Brick"};
        return ((this.getDamage() & 8) > 0 ? "Upper " : "") + names[this.getDamage() & 7] + " Slab";
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            case 0: {
                return BlockColor.ORANGE_BLOCK_COLOR;
            }
            case 1: {
                return BlockColor.MAGENTA_BLOCK_COLOR;
            }
            case 2: {
                return BlockColor.CYAN_BLOCK_COLOR;
            }
            case 3: 
            case 4: {
                return BlockColor.DIAMOND_BLOCK_COLOR;
            }
            default: {
                return BlockColor.STONE_BLOCK_COLOR;
            }
            case 6: {
                return BlockColor.SAND_BLOCK_COLOR;
            }
            case 7: 
        }
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)(this.getDamage() & 7));
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

