/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSugarcane;
import cn.nukkit.level.Level;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockSugarcane
extends BlockFlowable {
    public BlockSugarcane() {
        this(0);
    }

    public BlockSugarcane(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Sugarcane";
    }

    @Override
    public int getId() {
        return 83;
    }

    @Override
    public Item toItem() {
        return new ItemSugarcane();
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            int count = 1;
            for (int i = 1; i <= 2; ++i) {
                int id = this.level.getBlockIdAt(this.getFloorX(), this.getFloorY() - i, this.getFloorZ());
                if (id != 83) continue;
                ++count;
            }
            if (count < 3) {
                boolean success = false;
                int toGrow = 3 - count;
                for (int i = 1; i <= toGrow; ++i) {
                    Block block = this.up(i);
                    if (block.getId() == 0) {
                        BlockGrowEvent ev = new BlockGrowEvent(block, Block.get(83));
                        Server.getInstance().getPluginManager().callEvent(ev);
                        if (ev.isCancelled()) continue;
                        this.getLevel().setBlock((Vector3)block, ev.getNewState(), true);
                        success = true;
                        continue;
                    }
                    if (block.getId() != 83) break;
                }
                if (success) {
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        Level level = this.getLevel();
        if (type == 1) {
            level.scheduleUpdate(this, 0);
            return type;
        }
        if (type == 3) {
            if (!this.isSupportValid()) {
                level.useBreakOn(this);
            }
            return type;
        }
        if (type == 2) {
            int height;
            if (!this.isSupportValid()) {
                level.scheduleUpdate(this, 0);
                return type;
            }
            if (this.getDamage() < 15) {
                this.setDamage(this.getDamage() + 1);
                level.setBlock((Vector3)this, this, false);
                return type;
            }
            Block up = this.up();
            if (up.getId() != 0) {
                return type;
            }
            Block current = this;
            for (height = 0; height < 3 && ((Block)current).getId() == 83; ++height) {
                current = current.down();
            }
            if (height >= 3) {
                return type;
            }
            if (!level.setBlock((Vector3)up, Block.get(83), false)) {
                return type;
            }
            this.setDamage(0);
            level.setBlock((Vector3)this, this, false);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.getId() != 0) {
            return false;
        }
        if (this.isSupportValid()) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    private boolean isSupportValid() {
        Block down = this.down();
        int downId = down.getId();
        if (downId == 83) {
            return true;
        }
        if (downId != 2 && downId != 3 && downId != 12) {
            return false;
        }
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Block possibleWater = down.getSide(face);
            if (!(possibleWater instanceof BlockWater) && !(possibleWater instanceof BlockIceFrosted) && !(possibleWater.getLevelBlockAtLayer(1) instanceof BlockWater)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

