/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.player;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.player.PlayerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

public class PlayerAsyncPreLoginEvent
extends PlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private final String name;
    private final UUID uuid;
    private final String address;
    private final int port;
    private LoginResult loginResult = LoginResult.SUCCESS;
    private String kickMessage = "Plugin Reason";
    private final List<Consumer<Server>> scheduledActions = new ArrayList<Consumer<Server>>();

    public static HandlerList getHandlers() {
        return handlers;
    }

    public PlayerAsyncPreLoginEvent(String name, UUID uuid, String address, int port) {
        this.name = name;
        this.uuid = uuid;
        this.address = address;
        this.port = port;
    }

    @Override
    public Player getPlayer() {
        throw new UnsupportedOperationException("Could not get player instance in an async event");
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public LoginResult getLoginResult() {
        return this.loginResult;
    }

    public void setLoginResult(LoginResult loginResult) {
        this.loginResult = loginResult;
    }

    public String getKickMessage() {
        return this.kickMessage;
    }

    public void setKickMessage(String kickMessage) {
        this.kickMessage = kickMessage;
    }

    public void scheduleSyncAction(Consumer<Server> action) {
        this.scheduledActions.add(action);
    }

    public List<Consumer<Server>> getScheduledActions() {
        return new ArrayList<Consumer<Server>>(this.scheduledActions);
    }

    public void allow() {
        this.loginResult = LoginResult.SUCCESS;
    }

    public void disAllow(String message) {
        this.loginResult = LoginResult.KICK;
        this.kickMessage = message;
    }

    public static enum LoginResult {
        SUCCESS,
        KICK;

    }
}

