/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import cn.nukkit.utils.Utils;
import io.netty.util.collection.CharObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;

public class ShapedRecipe
implements CraftingRecipe {
    private String recipeId;
    private Item primaryResult;
    private List<Item> extraResults = new ArrayList<Item>();
    private long least;
    private long most;
    private final String[] shape;
    private final int priority;
    private final CharObjectHashMap<Item> ingredients = new CharObjectHashMap();

    public ShapedRecipe(Item primaryResult, String[] shape, Map<Character, Item> ingredients, List<Item> extraResults) {
        this(null, 1, primaryResult, shape, ingredients, extraResults);
    }

    public ShapedRecipe(String recipeId, int priority, Item primaryResult, String[] shape, Map<Character, Item> ingredients, List<Item> extraResults) {
        this.recipeId = recipeId;
        this.priority = priority;
        int rowCount = shape.length;
        if (rowCount > 3 || rowCount <= 0) {
            throw new RuntimeException("Shaped recipes may only have 1, 2 or 3 rows, not " + rowCount);
        }
        int columnCount = shape[0].length();
        if (columnCount > 3 || rowCount <= 0) {
            throw new RuntimeException("Shaped recipes may only have 1, 2 or 3 columns, not " + columnCount);
        }
        for (String row : shape) {
            if (row.length() != columnCount) {
                throw new RuntimeException("Shaped recipe rows must all have the same length (expected " + columnCount + ", got " + row.length() + ")");
            }
            for (int x = 0; x < columnCount; ++x) {
                char c = row.charAt(x);
                if (c == ' ' || ingredients.containsKey(Character.valueOf(c))) continue;
                throw new RuntimeException("No item specified for symbol '" + c + "'");
            }
        }
        this.primaryResult = primaryResult.clone();
        this.extraResults.addAll(extraResults);
        this.shape = shape;
        for (Map.Entry entry : ingredients.entrySet()) {
            this.setIngredient(((Character)entry.getKey()).charValue(), (Item)entry.getValue());
        }
    }

    public int getWidth() {
        return this.shape[0].length();
    }

    public int getHeight() {
        return this.shape.length;
    }

    @Override
    public Item getResult() {
        return this.primaryResult;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public UUID getId() {
        return new UUID(this.least, this.most);
    }

    @Override
    public void setId(UUID uuid) {
        this.least = uuid.getLeastSignificantBits();
        this.most = uuid.getMostSignificantBits();
        if (this.recipeId == null) {
            this.recipeId = this.getId().toString();
        }
    }

    public ShapedRecipe setIngredient(String key, Item item) {
        return this.setIngredient(key.charAt(0), item);
    }

    public ShapedRecipe setIngredient(char key, Item item) {
        if (String.join((CharSequence)"", this.shape).indexOf(key) < 0) {
            throw new RuntimeException("Symbol does not appear in the shape: " + key);
        }
        this.ingredients.put(key, (Object)item);
        return this;
    }

    public List<Item> getIngredientList() {
        ArrayList<Item> items = new ArrayList<Item>();
        int y2 = this.getHeight();
        for (int y = 0; y < y2; ++y) {
            int x2 = this.getWidth();
            for (int x = 0; x < x2; ++x) {
                items.add(this.getIngredient(x, y));
            }
        }
        return items;
    }

    public Map<Integer, Map<Integer, Item>> getIngredientMap() {
        LinkedHashMap<Integer, Map<Integer, Item>> ingredients = new LinkedHashMap<Integer, Map<Integer, Item>>();
        int y2 = this.getHeight();
        for (int y = 0; y < y2; ++y) {
            LinkedHashMap<Integer, Item> m = new LinkedHashMap<Integer, Item>();
            int x2 = this.getWidth();
            for (int x = 0; x < x2; ++x) {
                m.put(x, this.getIngredient(x, y));
            }
            ingredients.put(y, m);
        }
        return ingredients;
    }

    public Item getIngredient(int x, int y) {
        Item item = (Item)this.ingredients.get(this.shape[y].charAt(x));
        return item != null ? item.clone() : Item.get(0);
    }

    public String[] getShape() {
        return this.shape;
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerShapedRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPED;
    }

    @Override
    public List<Item> getExtraResults() {
        return this.extraResults;
    }

    @Override
    public List<Item> getAllResults() {
        ArrayList<Item> list = new ArrayList<Item>(this.extraResults);
        list.add(this.primaryResult);
        return list;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean matchItems(Item[][] input, Item[][] output) {
        if (!this.matchInputMap(Utils.clone2dArray(input))) {
            Item[][] reverse = Utils.clone2dArray(input);
            for (int y = 0; y < reverse.length; ++y) {
                reverse[y] = Utils.reverseArray(reverse[y], false);
            }
            if (!this.matchInputMap(reverse)) {
                return false;
            }
        }
        ArrayList<Item> haveItems = new ArrayList<Item>();
        for (Item[] items : output) {
            haveItems.addAll(Arrays.asList(items));
        }
        List<Item> needItems = this.getExtraResults();
        block2: for (Item haveItem : new ArrayList(haveItems)) {
            if (haveItem.isNull()) {
                haveItems.remove(haveItem);
                continue;
            }
            for (Item needItem : new ArrayList<Item>(needItems)) {
                if (!needItem.equals(haveItem, needItem.hasMeta(), needItem.hasCompoundTag()) || needItem.getCount() != haveItem.getCount()) continue;
                haveItems.remove(haveItem);
                needItems.remove(needItem);
                continue block2;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }

    private boolean matchInputMap(Item[][] input) {
        Map<Integer, Map<Integer, Item>> map = this.getIngredientMap();
        int y2 = this.getHeight();
        for (int y = 0; y < y2; ++y) {
            int x2 = this.getWidth();
            for (int x = 0; x < x2; ++x) {
                Item given = input[y][x];
                Item required = map.get(y).get(x);
                if (given == null || !required.equals(given, required.hasMeta(), required.hasCompoundTag()) || required.getCount() != given.getCount()) {
                    return false;
                }
                input[y][x] = null;
            }
        }
        Item[][] itemArray = input;
        int n = itemArray.length;
        for (int i = 0; i < n; ++i) {
            Item[] items;
            for (Item item : items = itemArray[i]) {
                if (item == null || item.isNull()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        this.ingredients.forEach((character, item) -> joiner.add(item.getName() + ":" + item.getDamage()));
        return joiner.toString();
    }

    @Override
    public boolean requiresCraftingTable() {
        return this.getHeight() > 2 || this.getWidth() > 2;
    }

    public static class Entry {
        public final int x;
        public final int y;

        public Entry(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

