/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import cn.nukkit.level.format.anvil.util.NibbleArray;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class BlockStorage {
    public static final int SECTION_SIZE = 4096;
    private final byte[] blockIds;
    private final byte[] blockIdsExtra;
    private final NibbleArray blockData;
    private final NibbleArray blockDataExtra;
    private transient boolean hasBlockIds;
    private transient boolean hasBlockIdExtras;
    private transient boolean hasBlockDataExtras;

    public BlockStorage() {
        this.blockIds = new byte[4096];
        this.blockIdsExtra = new byte[4096];
        this.blockData = new NibbleArray(4096);
        this.blockDataExtra = new NibbleArray(4096);
    }

    private BlockStorage(byte[] blockIds, byte[] blockIdsExtra, NibbleArray blockData, NibbleArray blockDataExtra) {
        this.blockIds = blockIds;
        this.blockIdsExtra = blockIdsExtra;
        this.blockData = blockData;
        this.blockDataExtra = blockDataExtra;
        this.recheckBlocks();
    }

    private static int getIndex(int x, int y, int z) {
        int index = (x << 8) + (z << 4) + y;
        Preconditions.checkArgument((index >= 0 && index < 4096 ? 1 : 0) != 0, (Object)"Invalid index");
        return index;
    }

    public int getBlockData(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        int base = this.blockData.get(index) & 0xF;
        int extra = this.hasBlockDataExtras ? this.blockDataExtra.get(index) & 0xF : 0;
        return extra << 4 | base;
    }

    public int getBlockDataExtra(int x, int y, int z) {
        if (!this.hasBlockDataExtras) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockDataExtra.get(index) & 0xF;
    }

    public int getBlockDataBase(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockData.get(index) & 0xF;
    }

    public int getBlockId(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockIds[index] & 0xFF | (this.hasBlockIdExtras ? (this.blockIdsExtra[index] & 0xFF) << 8 : 0);
    }

    public int getBlockIdBase(int x, int y, int z) {
        if (!this.hasBlockIds) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockIds[index] & 0xFF;
    }

    public int getBlockIdExtra(int x, int y, int z) {
        if (!this.hasBlockIdExtras) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z);
        return this.blockIdsExtra[index] & 0xFF;
    }

    public void setBlockId(int x, int y, int z, int id) {
        byte extraBase;
        byte blockBase;
        int index = BlockStorage.getIndex(x, y, z);
        this.blockIds[index] = blockBase = (byte)(id & 0xFF);
        this.blockIdsExtra[index] = extraBase = (byte)(id >> 8 & 0xFF);
        this.hasBlockIdExtras |= extraBase != 0;
        this.hasBlockIds |= blockBase != 0 | this.hasBlockIdExtras;
    }

    public void setBlockData(int x, int y, int z, int data) {
        int index = BlockStorage.getIndex(x, y, z);
        byte data1 = (byte)(data & 0xF);
        byte data2 = (byte)(data >> 4 & 3 & 0xF);
        this.blockData.set(index, data1);
        this.blockDataExtra.set(index, data2);
        this.hasBlockDataExtras |= data2 > 0;
        this.hasBlockIds |= data1 != 0 | this.hasBlockDataExtras;
    }

    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(BlockStorage.getIndex(x, y, z));
    }

    public void setFullBlock(int x, int y, int z, int value) {
        this.setFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    public int getAndSetFullBlock(int x, int y, int z, int value) {
        return this.getAndSetFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    private int getAndSetFullBlock(int index, int value) {
        Preconditions.checkArgument((value < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Invalid full block");
        byte oldBlockExtra = this.hasBlockIdExtras ? this.blockIdsExtra[index] : (byte)0;
        byte oldBlock = this.hasBlockIds ? this.blockIds[index] : (byte)0;
        byte oldData = this.hasBlockIds ? this.blockData.get(index) : (byte)0;
        byte oldDataExtra = this.hasBlockDataExtras ? this.blockDataExtra.get(index) : (byte)0;
        byte newBlockExtra = (byte)(value >> 14 & 0xFF);
        byte newBlock = (byte)(value >> 6 & 0xFF);
        byte newData = (byte)(value & 0xF);
        byte newDataExtra = (byte)(value >> 4 & 3 & 0xF);
        if (oldBlock != newBlock) {
            this.blockIds[index] = newBlock;
        }
        if (oldBlockExtra != newBlockExtra) {
            this.blockIdsExtra[index] = newBlockExtra;
        }
        if (oldData != newData) {
            this.blockData.set(index, newData);
        }
        if (oldDataExtra != newDataExtra) {
            this.blockDataExtra.set(index, newDataExtra);
        }
        this.hasBlockIdExtras |= newBlockExtra != 0;
        this.hasBlockDataExtras |= newDataExtra != 0;
        this.hasBlockIds |= newBlock != 0 | this.hasBlockIdExtras | this.hasBlockDataExtras;
        return (oldBlockExtra & 0xFF) << 14 | (oldBlock & 0xFF) << 6 | (oldDataExtra & 0xF) << 4 | oldData;
    }

    private int getFullBlock(int index) {
        if (!this.hasBlockIds) {
            return 0;
        }
        byte block = this.blockIds[index];
        byte extra = this.hasBlockIdExtras ? this.blockIdsExtra[index] : (byte)0;
        byte data = this.blockData.get(index);
        byte dataExtra = this.hasBlockDataExtras ? this.blockDataExtra.get(index) : (byte)0;
        return (extra & 0xFF) << 14 | (block & 0xFF) << 6 | (dataExtra & 0xF) << 4 | data;
    }

    private void setFullBlock(int index, int value) {
        Preconditions.checkArgument((value < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Invalid full block");
        byte extra = (byte)(value >> 14 & 0xFF);
        byte block = (byte)(value >> 6 & 0xFF);
        byte dataExtra = (byte)(value >> 4 & 3 & 0xF);
        byte data = (byte)(value & 0xF);
        this.blockIds[index] = block;
        this.blockIdsExtra[index] = extra;
        this.blockData.set(index, data);
        this.blockDataExtra.set(index, dataExtra);
        this.hasBlockIdExtras |= extra != 0;
        this.hasBlockDataExtras |= dataExtra != 0;
        this.hasBlockIds |= block != 0 | this.hasBlockIdExtras | this.hasBlockDataExtras;
    }

    public byte[] getBlockIds() {
        if (this.hasBlockIds) {
            return Arrays.copyOf(this.blockIds, this.blockIds.length);
        }
        return new byte[4096];
    }

    public byte[] getBlockIdsExtra() {
        if (this.hasBlockIdExtras) {
            return Arrays.copyOf(this.blockIdsExtra, this.blockIdsExtra.length);
        }
        return new byte[4096];
    }

    public byte[] getBlockData() {
        if (this.hasBlockIds) {
            return this.blockData.getData();
        }
        return new byte[2048];
    }

    public byte[] getBlockDataExtra() {
        if (this.hasBlockDataExtras) {
            return this.blockDataExtra.getData();
        }
        return new byte[2048];
    }

    public int[] getBlockIdsExtended() {
        int[] ids;
        block4: {
            ids = new int[4096];
            if (!this.hasBlockIds) break block4;
            if (this.hasBlockIdExtras) {
                for (int i = 0; i < 4096; ++i) {
                    ids[i] = this.blockIds[i] & 0xFF | (this.blockIdsExtra[i] & 0xFF) << 8;
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    ids[i] = this.blockIds[i] & 0xFF;
                }
            }
        }
        return ids;
    }

    public int[] getBlockDataExtended() {
        int[] data;
        block4: {
            data = new int[4096];
            if (!this.hasBlockIds) break block4;
            if (this.hasBlockDataExtras) {
                for (int i = 0; i < 4096; ++i) {
                    data[i] = this.blockData.get(i) & 0xF | (this.blockDataExtra.get(i) & 0xF) << 4;
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    data[i] = this.blockData.get(i) & 0xF;
                }
            }
        }
        return data;
    }

    public void recheckBlocks() {
        for (byte blockId : this.blockIdsExtra) {
            if (blockId == 0) continue;
            this.hasBlockIdExtras = true;
            break;
        }
        for (byte dataId : this.blockDataExtra.getData()) {
            if (dataId == 0) continue;
            this.hasBlockDataExtras = true;
            break;
        }
        if (this.hasBlockDataExtras || this.hasBlockIdExtras) {
            this.hasBlockIds = true;
        } else {
            for (byte blockId : this.blockIds) {
                if (blockId == 0) continue;
                this.hasBlockIds = true;
                break;
            }
        }
    }

    public BlockStorage copy() {
        return new BlockStorage((byte[])this.blockIds.clone(), (byte[])this.blockIdsExtra.clone(), this.blockData.copy(), this.blockDataExtra.copy());
    }

    public boolean hasBlockIds() {
        return this.hasBlockIds;
    }

    public boolean hasBlockIdExtras() {
        return this.hasBlockIdExtras;
    }

    public boolean hasBlockDataExtras() {
        return this.hasBlockDataExtras;
    }
}

