/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.mcregion;

import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseRegionLoader;
import cn.nukkit.level.format.mcregion.Chunk;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.Zlib;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;

public class RegionLoader
extends BaseRegionLoader {
    public RegionLoader(LevelProvider level, int regionX, int regionZ) {
        super(level, regionX, regionZ, "mcr");
    }

    @Override
    protected boolean isChunkGenerated(int index) {
        Integer[] array = (Integer[])this.locationTable.get(index);
        return array[0] != 0 && array[1] != 0;
    }

    @Override
    public Chunk readChunk(int x, int z) throws IOException {
        int index = RegionLoader.getChunkOffset(x, z);
        if (index < 0 || index >= 4096) {
            return null;
        }
        this.lastUsed = System.currentTimeMillis();
        if (!this.isChunkGenerated(index)) {
            return null;
        }
        Integer[] table = (Integer[])this.locationTable.get(index);
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(table[0] << 12);
        int length = raf.readInt();
        if (length <= 0 || length >= 0x100000) {
            if (length >= 0x100000) {
                table[0] = ++this.lastSector;
                table[1] = 1;
                this.locationTable.put(index, table);
                MainLogger.getLogger().error("Corrupted chunk header detected");
            }
            return null;
        }
        byte compression = raf.readByte();
        if (length > table[1] << 12) {
            MainLogger.getLogger().error("Corrupted bigger chunk detected");
            table[1] = length >> 12;
            this.locationTable.put(index, table);
            this.writeLocationIndex(index);
        } else if (compression != 2 && compression != 1) {
            MainLogger.getLogger().error("Invalid compression type");
            return null;
        }
        byte[] data = new byte[length - 1];
        raf.readFully(data);
        Chunk chunk = this.unserializeChunk(data);
        if (chunk != null) {
            return chunk;
        }
        MainLogger.getLogger().error("Corrupted chunk detected");
        return null;
    }

    @Override
    protected Chunk unserializeChunk(byte[] data) {
        return Chunk.fromBinary(data, this.levelProvider);
    }

    @Override
    public boolean chunkExists(int x, int z) {
        return this.isChunkGenerated(RegionLoader.getChunkOffset(x, z));
    }

    @Override
    protected void saveChunk(int x, int z, byte[] chunkData) throws IOException {
        int length = chunkData.length + 1;
        if (length + 4 > 0x100000) {
            throw new ChunkException("Chunk is too big! " + (length + 4) + " > " + 0x100000);
        }
        int sectors = (int)Math.ceil((double)(length + 4) / 4096.0);
        int index = RegionLoader.getChunkOffset(x, z);
        boolean indexChanged = false;
        Integer[] table = (Integer[])this.locationTable.get(index);
        if (table[1] < sectors) {
            table[0] = this.lastSector + 1;
            this.locationTable.put(index, table);
            this.lastSector += sectors;
            indexChanged = true;
        } else if (table[1] != sectors) {
            indexChanged = true;
        }
        table[1] = sectors;
        table[2] = (int)((double)System.currentTimeMillis() / 1000.0);
        this.locationTable.put(index, table);
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(table[0] << 12);
        BinaryStream stream = new BinaryStream();
        stream.put(Binary.writeInt(length));
        stream.putByte((byte)2);
        stream.put(chunkData);
        byte[] data = stream.getBuffer();
        if (data.length < sectors << 12) {
            byte[] newData = new byte[sectors << 12];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        raf.write(data);
        if (indexChanged) {
            this.writeLocationIndex(index);
        }
    }

    @Override
    public void removeChunk(int x, int z) {
        int index = RegionLoader.getChunkOffset(x, z);
        Integer[] table = (Integer[])this.locationTable.get(0);
        table[0] = 0;
        table[1] = 0;
        this.locationTable.put(index, table);
    }

    @Override
    public void writeChunk(FullChunk chunk) throws Exception {
        this.lastUsed = System.currentTimeMillis();
        byte[] chunkData = chunk.toBinary();
        this.saveChunk(chunk.getX() & 0x1F, chunk.getZ() & 0x1F, chunkData);
    }

    protected static int getChunkOffset(int x, int z) {
        return x | z << 5;
    }

    @Override
    public void close() throws IOException {
        this.writeLocationTable();
        this.levelProvider = null;
        super.close();
    }

    @Override
    public int doSlowCleanUp() throws Exception {
        RandomAccessFile raf = this.getRandomAccessFile();
        for (int i = 0; i < 1024; ++i) {
            Integer[] table = (Integer[])this.locationTable.get(i);
            if (table[0] == 0 || table[1] == 0) continue;
            raf.seek(table[0] << 12);
            byte[] chunk = new byte[table[1] << 12];
            raf.readFully(chunk);
            int length = Binary.readInt(Arrays.copyOfRange(chunk, 0, 3));
            if (length <= 1) {
                table = new Integer[]{0, 0, 0};
                this.locationTable.put(i, table);
            }
            try {
                chunk = Zlib.inflate(Arrays.copyOf(chunk, 5));
            }
            catch (Exception e) {
                this.locationTable.put(i, new Integer[]{0, 0, 0});
                continue;
            }
            chunk = Zlib.deflate(chunk, 9);
            ByteBuffer buffer = ByteBuffer.allocate(5 + chunk.length);
            buffer.put(Binary.writeInt(chunk.length + 1));
            buffer.put((byte)2);
            buffer.put(chunk);
            chunk = buffer.array();
            int sectors = (int)Math.ceil((double)chunk.length / 4096.0);
            if (sectors > table[1]) {
                table[0] = this.lastSector + 1;
                this.lastSector += sectors;
                this.locationTable.put(i, table);
            }
            raf.seek(table[0] << 12);
            byte[] bytes = new byte[sectors << 12];
            ByteBuffer buffer1 = ByteBuffer.wrap(bytes);
            buffer1.put(chunk);
            raf.write(buffer1.array());
        }
        this.writeLocationTable();
        int n = this.cleanGarbage();
        this.writeLocationTable();
        return n;
    }

    @Override
    protected void loadLocationTable() throws IOException {
        int i;
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(0L);
        this.lastSector = 1;
        int[] data = new int[2048];
        for (i = 0; i < 2048; ++i) {
            data[i] = raf.readInt();
        }
        for (i = 0; i < 1024; ++i) {
            int index = data[i];
            this.locationTable.put(i, new Integer[]{index >> 8, index & 0xFF, data[1024 + i]});
            int value = ((Integer[])this.locationTable.get(i))[0] + ((Integer[])this.locationTable.get(i))[1] - 1;
            if (value <= this.lastSector) continue;
            this.lastSector = value;
        }
    }

    private void writeLocationTable() throws IOException {
        Integer[] array;
        int i;
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(0L);
        for (i = 0; i < 1024; ++i) {
            array = (Integer[])this.locationTable.get(i);
            raf.writeInt(array[0] << 8 | array[1]);
        }
        for (i = 0; i < 1024; ++i) {
            array = (Integer[])this.locationTable.get(i);
            raf.writeInt(array[2]);
        }
    }

    private int cleanGarbage() throws IOException {
        TreeMap<Integer, Integer> sectors = new TreeMap<Integer, Integer>();
        Iterator iterator = new ArrayList(this.locationTable.keySet()).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            Integer[] data = (Integer[])this.locationTable.get(index);
            if (data[0] == 0 || data[1] == 0) {
                this.locationTable.put(index, new Integer[]{0, 0, 0});
                continue;
            }
            sectors.put(data[0], index);
        }
        if (sectors.size() == this.lastSector - 2) {
            return 0;
        }
        int shift = 0;
        int lastSector = 1;
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(8192L);
        int s = 2;
        Iterator iterator2 = sectors.keySet().iterator();
        while (iterator2.hasNext()) {
            Integer[] v;
            int sector;
            s = sector = ((Integer)iterator2.next()).intValue();
            int index = (Integer)sectors.get(sector);
            if (sector - lastSector > 1) {
                shift += sector - lastSector - 1;
            }
            if (shift > 0) {
                raf.seek(sector << 12);
                byte[] old = new byte[4096];
                raf.readFully(old);
                raf.seek(sector - shift << 12);
                raf.write(old);
            }
            Integer[] integerArray = v = (Integer[])this.locationTable.get(index);
            Integer.valueOf(integerArray[0] - shift);
            this.locationTable.put(index, v);
            this.lastSector = sector;
        }
        raf.setLength(s + 1 << 12);
        return shift;
    }

    @Override
    protected void writeLocationIndex(int index) throws IOException {
        Integer[] array = (Integer[])this.locationTable.get(index);
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(index << 2);
        raf.writeInt(array[0] << 8 | array[1]);
        raf.seek(4096 + (index << 2));
        raf.writeInt(array[2]);
    }

    @Override
    protected void createBlank() throws IOException {
        int i;
        RandomAccessFile raf = this.getRandomAccessFile();
        raf.seek(0L);
        raf.setLength(0L);
        this.lastSector = 1;
        int time = (int)((double)System.currentTimeMillis() / 1000.0);
        for (i = 0; i < 1024; ++i) {
            this.locationTable.put(i, new Integer[]{0, 0, time});
            raf.writeInt(0);
        }
        for (i = 0; i < 1024; ++i) {
            raf.writeInt(time);
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }
}

