/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.noise.nukkit.f;

import cn.nukkit.level.generator.noise.nukkit.f.NoiseF;
import cn.nukkit.math.NukkitRandom;

public class PerlinF
extends NoiseF {
    public PerlinF(NukkitRandom random, float octaves, float persistence) {
        this(random, octaves, persistence, 1.0f);
    }

    public PerlinF(NukkitRandom random, float octaves, float persistence, float expansion) {
        int i;
        this.octaves = octaves;
        this.persistence = persistence;
        this.expansion = expansion;
        this.offsetX = random.nextFloat() * 256.0f;
        this.offsetY = random.nextFloat() * 256.0f;
        this.offsetZ = random.nextFloat() * 256.0f;
        this.perm = new int[512];
        for (i = 0; i < 256; ++i) {
            this.perm[i] = random.nextBoundedInt(256);
        }
        for (i = 0; i < 256; ++i) {
            int pos = random.nextBoundedInt(256 - i) + i;
            int old = this.perm[i];
            this.perm[i] = this.perm[pos];
            this.perm[pos] = old;
            this.perm[i + 256] = this.perm[i];
        }
    }

    @Override
    public float getNoise2D(float x, float y) {
        return this.getNoise3D(x, y, 0.0f);
    }

    @Override
    public float getNoise3D(float x, float y, float z) {
        int floorX = (int)(x += this.offsetX);
        int floorY = (int)(y += this.offsetY);
        int floorZ = (int)(z += this.offsetZ);
        int X = floorX & 0xFF;
        int Y = floorY & 0xFF;
        int Z = floorZ & 0xFF;
        float fX = (x -= (float)floorX) * x * x * (x * (x * 6.0f - 15.0f) + 10.0f);
        float fY = (y -= (float)floorY) * y * y * (y * (y * 6.0f - 15.0f) + 10.0f);
        float fZ = (z -= (float)floorZ) * z * z * (z * (z * 6.0f - 15.0f) + 10.0f);
        int A = this.perm[X] + Y;
        int B = this.perm[X + 1] + Y;
        int AA = this.perm[A] + Z;
        int AB = this.perm[A + 1] + Z;
        int BA = this.perm[B] + Z;
        int BB = this.perm[B + 1] + Z;
        float AA1 = PerlinF.grad(this.perm[AA], x, y, z);
        float BA1 = PerlinF.grad(this.perm[BA], x - 1.0f, y, z);
        float AB1 = PerlinF.grad(this.perm[AB], x, y - 1.0f, z);
        float BB1 = PerlinF.grad(this.perm[BB], x - 1.0f, y - 1.0f, z);
        float AA2 = PerlinF.grad(this.perm[AA + 1], x, y, z - 1.0f);
        float BA2 = PerlinF.grad(this.perm[BA + 1], x - 1.0f, y, z - 1.0f);
        float AB2 = PerlinF.grad(this.perm[AB + 1], x, y - 1.0f, z - 1.0f);
        float BB2 = PerlinF.grad(this.perm[BB + 1], x - 1.0f, y - 1.0f, z - 1.0f);
        float xLerp11 = AA1 + fX * (BA1 - AA1);
        float zLerp1 = xLerp11 + fY * (AB1 + fX * (BB1 - AB1) - xLerp11);
        float xLerp21 = AA2 + fX * (BA2 - AA2);
        return zLerp1 + fZ * (xLerp21 + fY * (AB2 + fX * (BB2 - AB2) - xLerp21) - zLerp1);
    }
}

