/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.ore;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitRandom;

public class OreType {
    public final int fullId;
    public final int clusterCount;
    public final int clusterSize;
    public final int maxHeight;
    public final int minHeight;
    public final int replaceBlockId;

    public OreType(Block material, int clusterCount, int clusterSize, int minHeight, int maxHeight) {
        this(material, clusterCount, clusterSize, minHeight, maxHeight, 1);
    }

    public OreType(Block material, int clusterCount, int clusterSize, int minHeight, int maxHeight, int replaceBlockId) {
        this.fullId = material.getFullId();
        this.clusterCount = clusterCount;
        this.clusterSize = clusterSize;
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.replaceBlockId = replaceBlockId;
    }

    public boolean spawn(ChunkManager level, NukkitRandom rand, int replaceId, int x, int y, int z) {
        float piScaled = rand.nextFloat() * (float)Math.PI;
        double scaleMaxX = (float)(x + 8) + MathHelper.sin(piScaled) * (float)this.clusterSize / 8.0f;
        double scaleMinX = (float)(x + 8) - MathHelper.sin(piScaled) * (float)this.clusterSize / 8.0f;
        double scaleMaxZ = (float)(z + 8) + MathHelper.cos(piScaled) * (float)this.clusterSize / 8.0f;
        double scaleMinZ = (float)(z + 8) - MathHelper.cos(piScaled) * (float)this.clusterSize / 8.0f;
        double scaleMaxY = y + rand.nextBoundedInt(3) - 2;
        double scaleMinY = y + rand.nextBoundedInt(3) - 2;
        for (int i = 0; i < this.clusterSize; ++i) {
            float sizeIncr = (float)i / (float)this.clusterSize;
            double scaleX = scaleMaxX + (scaleMinX - scaleMaxX) * (double)sizeIncr;
            double scaleY = scaleMaxY + (scaleMinY - scaleMaxY) * (double)sizeIncr;
            double scaleZ = scaleMaxZ + (scaleMinZ - scaleMaxZ) * (double)sizeIncr;
            double randSizeOffset = rand.nextDouble() * (double)this.clusterSize / 16.0;
            double randVec1 = (double)(MathHelper.sin((float)Math.PI * sizeIncr) + 1.0f) * randSizeOffset + 1.0;
            double randVec2 = (double)(MathHelper.sin((float)Math.PI * sizeIncr) + 1.0f) * randSizeOffset + 1.0;
            int minX = MathHelper.floor(scaleX - randVec1 / 2.0);
            int minY = MathHelper.floor(scaleY - randVec2 / 2.0);
            int minZ = MathHelper.floor(scaleZ - randVec1 / 2.0);
            int maxX = MathHelper.floor(scaleX + randVec1 / 2.0);
            int maxY = MathHelper.floor(scaleY + randVec2 / 2.0);
            int maxZ = MathHelper.floor(scaleZ + randVec1 / 2.0);
            for (int xSeg = minX; xSeg <= maxX; ++xSeg) {
                double xVal = ((double)xSeg + 0.5 - scaleX) / (randVec1 / 2.0);
                if (!(xVal * xVal < 1.0)) continue;
                for (int ySeg = minY; ySeg <= maxY; ++ySeg) {
                    double yVal = ((double)ySeg + 0.5 - scaleY) / (randVec2 / 2.0);
                    if (!(xVal * xVal + yVal * yVal < 1.0)) continue;
                    for (int zSeg = minZ; zSeg <= maxZ; ++zSeg) {
                        double zVal = ((double)zSeg + 0.5 - scaleZ) / (randVec1 / 2.0);
                        if (!(xVal * xVal + yVal * yVal + zVal * zVal < 1.0) || level.getBlockIdAt(xSeg, ySeg, zSeg) != this.replaceBlockId) continue;
                        level.setBlockFullIdAt(xSeg, ySeg, zSeg, this.fullId);
                    }
                }
            }
        }
        return true;
    }
}

