/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBeehive;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.List;

public class BlockBeehive
extends BlockSolidMeta
implements Faceable {
    public BlockBeehive() {
        this(0);
    }

    protected BlockBeehive(int meta) {
        super(meta);
    }

    @Override
    public void setDamage(int meta) {
        super.setDamage(meta);
    }

    @Override
    public int getId() {
        return 474;
    }

    @Override
    public String getName() {
        return "Beehive";
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (player == null) {
            this.setDamage(0);
        } else {
            this.setDamage(player.getDirection().getOpposite().getHorizontalIndex());
        }
        int honeyLevel = item.hasCustomBlockData() ? item.getCustomBlockData().getByte("HoneyLevel") : 0;
        this.setHoneyLevel(honeyLevel);
        this.level.setBlock((Vector3)this, this, true, true);
        BlockEntityBeehive beehive = this.createEntity(item.getCustomBlockData());
        if (beehive == null) {
            return false;
        }
        if (beehive.namedTag.getByte("ShouldSpawnBees") > 0) {
            List<BlockFace> validSpawnFaces = beehive.scanValidSpawnFaces(true);
            for (BlockEntityBeehive.Occupant occupant : beehive.getOccupants()) {
                beehive.spawnOccupant(occupant, validSpawnFaces);
            }
            beehive.namedTag.putByte("ShouldSpawnBees", 0);
        }
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 359 && this.isFull()) {
            this.honeyCollected(player);
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_BEEHIVE_SHEAR);
            item.useOn(this);
            for (int i = 0; i < 3; ++i) {
                this.level.dropItem(this, Item.get(736));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public void honeyCollected(Player player) {
        this.honeyCollected(player, this.level.getServer().getDifficulty() > 0 && !player.isCreative());
    }

    public void honeyCollected(Player player, boolean angerBees) {
        this.setHoneyLevel(0);
        if (this.down().getId() != 464 && angerBees) {
            this.angerBees(player);
        }
    }

    public void angerBees(Player player) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (blockEntity instanceof BlockEntityBeehive) {
            BlockEntityBeehive beehive = (BlockEntityBeehive)blockEntity;
            beehive.angerBees(player);
        }
    }

    @Override
    public Item toItem() {
        BlockEntity entity;
        Item item = Item.get(this.getItemId(), 0, 1);
        if (this.level != null && (entity = this.level.getBlockEntity(this)) instanceof BlockEntityBeehive) {
            BlockEntityBeehive beehive = (BlockEntityBeehive)entity;
            entity.saveNBT();
            if (!beehive.isHoneyEmpty() || !beehive.isEmpty()) {
                CompoundTag copy = entity.namedTag.copy();
                copy.putByte("HoneyLevel", this.getHoneyLevel());
                item.setCustomBlockData(copy);
            }
        }
        return item;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean mustSilkTouch(Vector3 vector, int layer, BlockFace face, Item item, Player player) {
        BlockEntity blockEntity;
        if (player != null && (blockEntity = this.getLevel().getBlockEntity(this)) instanceof BlockEntityBeehive && !((BlockEntityBeehive)blockEntity).isEmpty()) {
            return true;
        }
        return super.mustSilkTouch(vector, layer, face, item, player);
    }

    @Override
    public boolean mustDrop(Vector3 vector, int layer, BlockFace face, Item item, Player player) {
        return this.mustSilkTouch(vector, layer, face, item, player) || super.mustDrop(vector, layer, face, item, player);
    }

    @Override
    public boolean canHarvestWithHand() {
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemBlock(new BlockBeehive())};
    }

    public BlockEntityBeehive getOrCreateEntity() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (blockEntity instanceof BlockEntityBeehive) {
            return (BlockEntityBeehive)blockEntity;
        }
        return this.createEntity(null);
    }

    private BlockEntityBeehive createEntity(CompoundTag customNbt) {
        CompoundTag nbt = customNbt != null ? customNbt.copy() : new CompoundTag();
        nbt.setName("");
        nbt.putString("id", "Beehive").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        return (BlockEntityBeehive)BlockEntity.createBlockEntity("Beehive", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    public void setBlockFace(BlockFace face) {
        this.setDamage(this.getDamage() & 0x38 | face.getIndex() & 7);
    }

    public void setHoneyLevel(int honeyLevel) {
        honeyLevel = NukkitMath.clamp(honeyLevel, 0, 5);
        this.setDamage(this.getDamage() & 7 | honeyLevel << 3);
    }

    public int getHoneyLevel() {
        return this.getDamage() >> 3 & 7;
    }

    public boolean isEmpty() {
        return (this.getDamage() & 0x38) == 0;
    }

    public boolean isFull() {
        return (this.getDamage() & 0x38) == 56;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getHoneyLevel();
    }
}

