/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockGrindstone
extends BlockTransparentMeta
implements Faceable {
    public static final int TYPE_ATTACHMENT_STANDING = 0;
    public static final int TYPE_ATTACHMENT_HANGING = 1;
    public static final int TYPE_ATTACHMENT_SIDE = 2;
    public static final int TYPE_ATTACHMENT_MULTIPLE = 3;

    public BlockGrindstone() {
        this(0);
    }

    public BlockGrindstone(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 450;
    }

    @Override
    public String getName() {
        return "Grindstone";
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockGrindstone());
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public void setBlockFace(BlockFace face) {
        if (face.getHorizontalIndex() == -1) {
            return;
        }
        this.setDamage(this.getDamage() & 0x3C | face.getHorizontalIndex());
    }

    public int getAttachmentType() {
        return (this.getDamage() & 0xC) >> 2 & 3;
    }

    public void setAttachmentType(int attachmentType) {
        this.setDamage(this.getDamage() & 0x33 | (attachmentType &= 3) << 2);
    }

    private boolean isConnectedTo(BlockFace connectedFace, int attachmentType, BlockFace blockFace) {
        BlockFace.Axis faceAxis = connectedFace.getAxis();
        switch (attachmentType) {
            case 0: {
                if (faceAxis == BlockFace.Axis.Y) {
                    return connectedFace == BlockFace.DOWN;
                }
                return false;
            }
            case 1: {
                return connectedFace == BlockFace.UP;
            }
            case 2: 
            case 3: {
                return connectedFace == blockFace.getOpposite();
            }
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.checkSupport()) {
                this.level.useBreakOn(this, Item.get(278));
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.getId() != 106 && block.canBeReplaced() && block.getId() != 0 && block.getId() != 415 && !(block instanceof BlockLiquid)) {
            face = BlockFace.UP;
        }
        switch (face) {
            case UP: {
                this.setAttachmentType(0);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            case DOWN: {
                this.setAttachmentType(1);
                this.setBlockFace(player.getDirection().getOpposite());
                break;
            }
            default: {
                this.setBlockFace(face);
                this.setAttachmentType(2);
            }
        }
        if (!this.checkSupport()) {
            return false;
        }
        this.level.setBlock((Vector3)this, this, true, true);
        return true;
    }

    private boolean checkSupport() {
        switch (this.getAttachmentType()) {
            case 0: {
                if (!this.checkSupport(this.down())) break;
                return true;
            }
            case 1: {
                if (!this.checkSupport(this.up())) break;
                return true;
            }
            case 2: {
                BlockFace blockFace = this.getBlockFace();
                if (!this.checkSupport(this.getSide(blockFace.getOpposite()))) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkSupport(Block support) {
        int id = support.getId();
        return id != 0 && id != 415 && !(support instanceof BlockLiquid);
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        int attachmentType = this.getAttachmentType();
        BlockFace blockFace = this.getBlockFace();
        boolean south = this.isConnectedTo(BlockFace.SOUTH, attachmentType, blockFace);
        boolean north = this.isConnectedTo(BlockFace.NORTH, attachmentType, blockFace);
        boolean west = this.isConnectedTo(BlockFace.WEST, attachmentType, blockFace);
        boolean east = this.isConnectedTo(BlockFace.EAST, attachmentType, blockFace);
        boolean up = this.isConnectedTo(BlockFace.UP, attachmentType, blockFace);
        boolean down = this.isConnectedTo(BlockFace.DOWN, attachmentType, blockFace);
        double pixels = 0.125;
        double n = north ? 0.0 : pixels;
        double s = south ? 1.0 : 1.0 - pixels;
        double w = west ? 0.0 : pixels;
        double e = east ? 1.0 : 1.0 - pixels;
        double d = down ? 0.0 : pixels;
        double u = up ? 1.0 : 1.0 - pixels;
        return new SimpleAxisAlignedBB(this.x + w, this.y + d, this.z + n, this.x + e, this.y + u, this.z + s);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            player.addWindow(new GrindstoneInventory(player.getUIInventory(), this), 2);
        }
        return true;
    }
}

