/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.LecternDropBookEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockLectern
extends BlockTransparentMeta
implements Faceable {
    public BlockLectern() {
        this(0);
    }

    public BlockLectern(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lectern";
    }

    @Override
    public int getId() {
        return 449;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 12.5;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.89999;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityLectern lectern;
        int power = 0;
        int page = 0;
        int maxPage = 0;
        BlockEntity be = this.getLevel().getBlockEntity(this);
        if (be instanceof BlockEntityLectern && (lectern = (BlockEntityLectern)be).hasBook()) {
            maxPage = lectern.getTotalPages();
            page = lectern.getLeftPage() + 1;
            power = (int)((float)page / (float)maxPage * 16.0f);
        }
        return power;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    public void setBlockFace(BlockFace face) {
        int horizontalIndex = face.getHorizontalIndex();
        if (horizontalIndex >= 0) {
            this.setDamage(this.getDamage() & 0x3C | horizontalIndex & 3);
        }
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setBlockFace(player != null ? player.getDirection().getOpposite() : BlockFace.SOUTH);
        CompoundTag nbt = new CompoundTag().putString("id", "Lectern").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        BlockEntityLectern lectern = (BlockEntityLectern)BlockEntity.createBlockEntity("Lectern", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
        if (lectern == null) {
            return false;
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntityLectern lectern;
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityLectern) {
                lectern = (BlockEntityLectern)t;
            } else {
                CompoundTag nbt = new CompoundTag().putString("id", "Lectern").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
                lectern = (BlockEntityLectern)BlockEntity.createBlockEntity("Lectern", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
                if (lectern == null) {
                    return false;
                }
            }
            Item currentBook = lectern.getBook();
            if (currentBook.getId() == 0 && (item.getId() == 387 || item.getId() == 386)) {
                Item newBook = item.clone();
                if (player.isSurvival()) {
                    newBook.setCount(newBook.getCount() - 1);
                    player.getInventory().setItemInHand(newBook);
                }
                newBook.setCount(1);
                lectern.setBook(newBook);
                lectern.spawnToAll();
                this.getLevel().addSound(this.add(0.5, 0.5, 0.5), Sound.ITEM_BOOK_PUT);
            }
        }
        return true;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    public boolean isActivated() {
        return (this.getDamage() & 4) == 4;
    }

    public void setActivated(boolean activated) {
        if (activated) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    public void executeRedstonePulse() {
        if (this.isActivated()) {
            this.level.cancelSheduledUpdate(this, this);
        } else {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
        }
        this.level.scheduleUpdate(this, this, 4);
        this.setActivated(true);
        this.level.setBlock((Vector3)this, this, true, false);
        this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.ITEM_BOOK_PAGE_TURN);
        this.level.updateAroundRedstone(this, null);
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return 0;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            if (this.isActivated()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
                this.setActivated(false);
                this.level.setBlock((Vector3)this, this, true, false);
                this.level.updateAroundRedstone(this, null);
            }
            return 3;
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public void dropBook(Player player) {
        BlockEntityLectern lectern;
        Item book;
        BlockEntity t = this.getLevel().getBlockEntity(this);
        if (t instanceof BlockEntityLectern && (book = (lectern = (BlockEntityLectern)t).getBook()).getId() != 0) {
            LecternDropBookEvent dropBookEvent = new LecternDropBookEvent(player, lectern, book);
            this.getLevel().getServer().getPluginManager().callEvent(dropBookEvent);
            if (!dropBookEvent.isCancelled()) {
                lectern.setBook(Item.get(0));
                lectern.spawnToAll();
                this.level.dropItem(lectern.add(0.5, 0.6f, 0.5), dropBookEvent.getBook());
            }
        }
    }
}

