/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.item.Item;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Rail;

public class BlockRailPowered
extends BlockRail {
    public BlockRailPowered() {
        this(0);
        this.canBePowered = true;
    }

    public BlockRailPowered(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 27;
    }

    @Override
    public String getName() {
        return "Powered Rail";
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 || type == 6 || type == 3) {
            boolean isPowered;
            if (super.onUpdate(type) == 1) {
                return 0;
            }
            if (!this.level.getServer().isRedstoneEnabled()) {
                return 0;
            }
            boolean wasPowered = this.isActive();
            boolean bl = isPowered = this.level.isBlockPowered(this.getLocation()) || this.checkSurrounding(this, true, 0) || this.checkSurrounding(this, false, 0);
            if (wasPowered != isPowered) {
                this.setActive(isPowered);
                this.level.updateAround(this.down());
                if (this.getOrientation().isAscending()) {
                    this.level.updateAround(this.up());
                }
            }
            return type;
        }
        return 0;
    }

    private boolean checkSurrounding(Vector3 pos, boolean relative, int power) {
        int dz;
        int dy;
        if (power >= 8) {
            return false;
        }
        int dx = pos.getFloorX();
        Block block2 = this.level.getBlock(new Vector3(dx, dy = pos.getFloorY(), dz = pos.getFloorZ()));
        if (!Rail.isRailBlock(block2)) {
            return false;
        }
        BlockRail block = (BlockRail)block2;
        Rail.Orientation base = null;
        boolean onStraight = true;
        switch (block.getOrientation()) {
            case STRAIGHT_NORTH_SOUTH: {
                if (relative) {
                    ++dz;
                    break;
                }
                --dz;
                break;
            }
            case STRAIGHT_EAST_WEST: {
                if (relative) {
                    --dx;
                    break;
                }
                ++dx;
                break;
            }
            case ASCENDING_EAST: {
                if (relative) {
                    --dx;
                } else {
                    ++dx;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (relative) {
                    --dx;
                    ++dy;
                    onStraight = false;
                } else {
                    ++dx;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (relative) {
                    ++dz;
                } else {
                    --dz;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (relative) {
                    ++dz;
                    ++dy;
                    onStraight = false;
                } else {
                    --dz;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            default: {
                return false;
            }
        }
        return this.canPowered(new Vector3(dx, dy, dz), base, power, relative) || onStraight && this.canPowered(new Vector3(dx, dy - 1, dz), base, power, relative);
    }

    protected boolean canPowered(Vector3 pos, Rail.Orientation state, int power, boolean relative) {
        Block block = this.level.getBlock(pos);
        if (!(block instanceof BlockRailPowered)) {
            return false;
        }
        Rail.Orientation base = ((BlockRailPowered)block).getOrientation();
        return (state != Rail.Orientation.STRAIGHT_EAST_WEST || base != Rail.Orientation.STRAIGHT_NORTH_SOUTH && base != Rail.Orientation.ASCENDING_NORTH && base != Rail.Orientation.ASCENDING_SOUTH) && (state != Rail.Orientation.STRAIGHT_NORTH_SOUTH || base != Rail.Orientation.STRAIGHT_EAST_WEST && base != Rail.Orientation.ASCENDING_EAST && base != Rail.Orientation.ASCENDING_WEST) && (this.level.isBlockPowered(pos) || this.checkSurrounding(pos, relative, power + 1));
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(27, 0, 1)};
    }
}

