/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.CloudParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayDeque;

public class BlockSponge
extends BlockSolidMeta {
    public static final int DRY = 0;
    public static final int WET = 1;
    private static final String[] NAMES = new String[]{"Sponge", "Wet sponge"};

    public BlockSponge() {
        this(0);
    }

    public BlockSponge(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() & 1];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.YELLOW_BLOCK_COLOR;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean blockSet;
        block2: {
            Level level;
            block3: {
                level = block.getLevel();
                blockSet = level.setBlock(block, this);
                if (!blockSet) break block2;
                if (this.getDamage() != 1 || level.getDimension() != 1) break block3;
                level.setBlock(block, Block.get(19, 0));
                this.getLevel().addSound(block.getLocation(), Sound.RANDOM_FIZZ);
                for (int i = 0; i < 8; ++i) {
                    this.getLevel().addParticle(new CloudParticle(block.getLocation().add(Math.random(), 1.0, Math.random())));
                }
                break block2;
            }
            if (this.getDamage() != 0 || !this.performWaterAbsorb(block)) break block2;
            level.setBlock(block, Block.get(19, 1));
            for (int i = 0; i < 4; ++i) {
                level.addLevelEvent(2001, GlobalBlockPalette.getOrCreateRuntimeId(8, 0), block);
            }
        }
        return blockSet;
    }

    private boolean performWaterAbsorb(Block block) {
        Entry entry;
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>();
        entries.add(new Entry(block, 0));
        int waterRemoved = 0;
        while (waterRemoved < 64 && (entry = (Entry)entries.poll()) != null) {
            for (BlockFace face : BlockFace.values()) {
                Block faceBlock = entry.block.getSide(face);
                if (faceBlock.getId() == 8 || faceBlock.getId() == 9) {
                    this.level.setBlock(faceBlock, Block.get(0));
                    ++waterRemoved;
                    if (entry.distance >= 6) continue;
                    entries.add(new Entry(faceBlock, entry.distance + 1));
                    continue;
                }
                if (faceBlock.getId() != 0 || entry.distance >= 6) continue;
                entries.add(new Entry(faceBlock, entry.distance + 1));
            }
        }
        return waterRemoved > 0;
    }

    private static class Entry {
        private final Block block;
        private final int distance;

        public Entry(Block block, int distance) {
            this.block = block;
            this.distance = distance;
        }
    }
}

