/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.GenericParticle;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;

public class EntitySnowball
extends EntityProjectile {
    public static final int NETWORK_ID = 81;

    @Override
    public int getNetworkId() {
        return 81;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    protected float getGravity() {
        return 0.03f;
    }

    @Override
    protected float getDrag() {
        return 0.01f;
    }

    public EntitySnowball(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntitySnowball(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.age > 1200 || this.isCollided) {
            this.kill();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    protected void addHitEffect() {
        int particles = ThreadLocalRandom.current().nextInt(10) + 5;
        for (int i = 0; i < particles; ++i) {
            this.level.addParticle(new GenericParticle(this, 14));
        }
    }
}

