/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.InventoryClickEvent;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.item.Item;
import cn.nukkit.utils.MainLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InventoryTransaction {
    private long creationTime;
    protected boolean hasExecuted;
    protected Player source;
    protected Set<Inventory> inventories = new HashSet<Inventory>();
    protected Set<InventoryAction> actions = new LinkedHashSet<InventoryAction>();

    public InventoryTransaction(Player source, List<InventoryAction> actions) {
        this(source, actions, true);
    }

    public InventoryTransaction(Player source, List<InventoryAction> actions, boolean init) {
        if (init) {
            this.init(source, actions);
        }
    }

    protected void init(Player source, List<InventoryAction> actions) {
        this.creationTime = System.currentTimeMillis();
        this.source = source;
        for (InventoryAction action : actions) {
            this.addAction(action);
        }
    }

    public Player getSource() {
        return this.source;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Set<Inventory> getInventories() {
        return this.inventories;
    }

    public Set<InventoryAction> getActions() {
        return this.actions;
    }

    public void addAction(InventoryAction action) {
        if (this.actions.contains(action)) {
            throw new RuntimeException("Tried to add the same action to a transaction twice");
        }
        this.actions.add(action);
        action.onAddToTransaction(this);
    }

    public void addInventory(Inventory inventory) {
        this.inventories.add(inventory);
    }

    protected boolean matchItems(List<Item> needItems, List<Item> haveItems) {
        for (InventoryAction action : this.actions) {
            if (action.getTargetItem().getId() != 0) {
                needItems.add(action.getTargetItem());
            }
            if (!action.isValid(this.source)) {
                return false;
            }
            if (action.getSourceItem().getId() == 0) continue;
            haveItems.add(action.getSourceItem());
        }
        block1: for (Item needItem : new ArrayList<Item>(needItems)) {
            for (Item haveItem : new ArrayList<Item>(haveItems)) {
                if (!needItem.equals(haveItem)) continue;
                int amount = Math.min(haveItem.getCount(), needItem.getCount());
                needItem.setCount(needItem.getCount() - amount);
                haveItem.setCount(haveItem.getCount() - amount);
                if (haveItem.getCount() == 0) {
                    haveItems.remove(haveItem);
                }
                if (needItem.getCount() != 0) continue;
                needItems.remove(needItem);
                continue block1;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }

    protected void sendInventories() {
        for (Inventory inventory : this.inventories) {
            inventory.sendContents(this.source);
            if (!(inventory instanceof PlayerInventory)) continue;
            ((PlayerInventory)inventory).sendArmorContents(this.source);
        }
    }

    protected boolean squashDuplicateSlotChanges() {
        List<SlotChangeAction> list;
        int hash;
        HashMap<Integer, ArrayList<SlotChangeAction>> slotChanges = new HashMap<Integer, ArrayList<SlotChangeAction>>();
        for (InventoryAction inventoryAction : this.actions) {
            if (!(inventoryAction instanceof SlotChangeAction)) continue;
            hash = Objects.hash(((SlotChangeAction)inventoryAction).getInventory(), ((SlotChangeAction)inventoryAction).getSlot());
            list = (List)slotChanges.get(hash);
            if (list == null) {
                list = new ArrayList<SlotChangeAction>();
            }
            list.add((SlotChangeAction)inventoryAction);
            slotChanges.put(hash, (ArrayList<SlotChangeAction>)list);
        }
        for (Map.Entry entry : new ArrayList(slotChanges.entrySet())) {
            int sortedThisLoop;
            hash = (Integer)entry.getKey();
            list = (ArrayList<SlotChangeAction>)entry.getValue();
            if (list.size() == 1) {
                slotChanges.remove(hash);
                continue;
            }
            ArrayList originalList = new ArrayList(list);
            SlotChangeAction originalAction = null;
            Item lastTargetItem = null;
            for (int i = 0; i < list.size(); ++i) {
                SlotChangeAction action = (SlotChangeAction)list.get(i);
                if (!action.isValid(this.source)) continue;
                originalAction = action;
                lastTargetItem = action.getTargetItem();
                list.remove(i);
                break;
            }
            if (originalAction == null) {
                return false;
            }
            do {
                sortedThisLoop = 0;
                for (int i = 0; i < list.size(); ++i) {
                    SlotChangeAction action = (SlotChangeAction)list.get(i);
                    Item actionSource = action.getSourceItem();
                    if (actionSource.equalsExact(lastTargetItem)) {
                        lastTargetItem = action.getTargetItem();
                        list.remove(i);
                        ++sortedThisLoop;
                        continue;
                    }
                    if (!actionSource.equals(lastTargetItem)) continue;
                    lastTargetItem.count -= actionSource.count;
                    list.remove(i);
                    if (lastTargetItem.count != 0) continue;
                    ++sortedThisLoop;
                }
            } while (sortedThisLoop > 0);
            if (list.size() > 0) {
                MainLogger.getLogger().debug("Failed to compact " + originalList.size() + " actions for " + this.source.getName());
                return false;
            }
            for (SlotChangeAction action : originalList) {
                this.actions.remove(action);
            }
            this.addAction(new SlotChangeAction(originalAction.getInventory(), originalAction.getSlot(), originalAction.getSourceItem(), lastTargetItem));
            MainLogger.getLogger().debug("Successfully compacted " + originalList.size() + " actions for " + this.source.getName());
        }
        return true;
    }

    public boolean canExecute() {
        this.squashDuplicateSlotChanges();
        ArrayList<Item> haveItems = new ArrayList<Item>();
        ArrayList<Item> needItems = new ArrayList<Item>();
        return this.matchItems(needItems, haveItems) && this.actions.size() > 0 && haveItems.size() == 0 && needItems.size() == 0;
    }

    protected boolean callExecuteEvent() {
        InventoryTransactionEvent ev = new InventoryTransactionEvent(this);
        this.source.getServer().getPluginManager().callEvent(ev);
        InventoryAction from = null;
        SlotChangeAction to = null;
        Player who = null;
        for (InventoryAction action : this.actions) {
            if (!(action instanceof SlotChangeAction)) continue;
            SlotChangeAction slotChange = (SlotChangeAction)action;
            if (slotChange.getInventory() instanceof PlayerInventory) {
                who = (Player)slotChange.getInventory().getHolder();
            }
            if (from == null) {
                from = slotChange;
                continue;
            }
            to = slotChange;
        }
        if (who != null && to != null) {
            if (from.getTargetItem().getCount() > from.getSourceItem().getCount()) {
                from = to;
            }
            InventoryClickEvent ev2 = new InventoryClickEvent(who, ((SlotChangeAction)from).getInventory(), ((SlotChangeAction)from).getSlot(), from.getSourceItem(), from.getTargetItem());
            this.source.getServer().getPluginManager().callEvent(ev2);
            if (ev2.isCancelled()) {
                return false;
            }
        }
        return !ev.isCancelled();
    }

    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.sendInventories();
            return false;
        }
        if (!this.callExecuteEvent()) {
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.onPreExecute(this.source)) continue;
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        this.hasExecuted = true;
        return true;
    }

    public boolean hasExecuted() {
        return this.hasExecuted;
    }
}

