/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.food;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.item.food.FoodNormal;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class FoodChorusFruit
extends FoodNormal {
    public FoodChorusFruit() {
        super(4, 2.4f);
        this.addRelative(432);
    }

    @Override
    protected boolean onEatenBy(Player player) {
        super.onEatenBy(player);
        int minX = player.getFloorX() - 8;
        int minY = player.getFloorY() - 8;
        int minZ = player.getFloorZ() - 8;
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        Level level = player.getLevel();
        if (level == null) {
            return false;
        }
        NukkitRandom random = new NukkitRandom();
        for (int attempts = 0; attempts < 128; ++attempts) {
            int y;
            int x = random.nextRange(minX, maxX);
            int z = random.nextRange(minZ, maxZ);
            if (y < 0) continue;
            for (y = random.nextRange(minY, maxY); y >= 0 && !level.getBlock(new Vector3(x, y + 1, z)).isSolid(); --y) {
            }
            Block blockUp = level.getBlock(new Vector3(x, ++y + 1, z));
            Block blockUp2 = level.getBlock(new Vector3(x, y + 2, z));
            if (blockUp.isSolid() || blockUp instanceof BlockLiquid || blockUp2.isSolid() || blockUp2 instanceof BlockLiquid) continue;
            level.addSound(player.asBlockVector3().asVector3(), Sound.MOB_ENDERMEN_PORTAL);
            player.teleport(new Vector3((double)x + 0.5, y + 1, (double)z + 0.5), PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT);
            level.addSound(player.asBlockVector3().asVector3(), Sound.MOB_ENDERMEN_PORTAL);
            break;
        }
        return true;
    }
}

