/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Server;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalBlockPalette {
    private static final Int2IntMap legacyToRuntimeId;
    private static final Int2IntMap runtimeIdToLegacy;
    private static final Int2ObjectMap<String> legacyIdToString;
    private static final Map<String, Integer> stringToLegacyId;
    private static final AtomicInteger runtimeIdAllocator;
    public static final byte[] BLOCK_PALETTE;
    private static final Int2ObjectMap<IntSet> unknownRuntimeIds;

    public static int getOrCreateRuntimeId(int id, int meta) {
        int legacyId;
        int runtimeId;
        if (id == 0) {
            meta = 0;
        }
        if ((runtimeId = legacyToRuntimeId.get(legacyId = id << 6 | meta)) == -1) {
            runtimeId = legacyToRuntimeId.get(15872);
            if (((IntSet)unknownRuntimeIds.computeIfAbsent(id, k -> new IntOpenHashSet(5))).add(meta)) {
                Server.getInstance().getLogger().error("Found an unknown BlockId:Meta combination: " + id + ":" + meta + ", replacing with an \"UPDATE!\" block.");
            }
        }
        return runtimeId;
    }

    public static int getOrCreateRuntimeId(int legacyId) throws NoSuchElementException {
        return GlobalBlockPalette.getOrCreateRuntimeId(legacyId >> 6, legacyId & 0x3F);
    }

    public static int getLegacyId(int runtimeId) {
        return runtimeIdToLegacy.get(runtimeId);
    }

    public static String getName(int id) {
        return (String)legacyIdToString.get(id);
    }

    /*
     * WARNING - void declaration
     */
    static {
        ListTag tag;
        Object states;
        legacyToRuntimeId = new Int2IntOpenHashMap();
        runtimeIdToLegacy = new Int2IntOpenHashMap();
        legacyIdToString = new Int2ObjectOpenHashMap();
        stringToLegacyId = new HashMap<String, Integer>();
        runtimeIdAllocator = new AtomicInteger(0);
        unknownRuntimeIds = new Int2ObjectOpenHashMap();
        legacyToRuntimeId.defaultReturnValue(-1);
        runtimeIdToLegacy.defaultReturnValue(-1);
        LinkedHashMap<CompoundTag, List<CompoundTag>> metaOverrides = new LinkedHashMap<CompoundTag, List<CompoundTag>>();
        try (InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_block_states_overrides.dat");){
            if (stream == null) {
                throw new AssertionError((Object)"Unable to locate block state nbt");
            }
            Throwable throwable = null;
            try (BufferedInputStream buffered = new BufferedInputStream(stream);){
                states = NBTIO.read(buffered).getList("Overrides", CompoundTag.class);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (CompoundTag compoundTag : ((ListTag)states).getAll()) {
                if (!compoundTag.contains("block") || !compoundTag.contains("LegacyStates")) continue;
                metaOverrides.put(compoundTag.getCompound("block").remove("version"), compoundTag.getList("LegacyStates", CompoundTag.class).getAll());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_block_states.dat");
            states = null;
            try {
                if (stream == null) {
                    throw new AssertionError((Object)"Unable to locate block state nbt");
                }
                Throwable throwable = null;
                try (BufferedInputStream buffered2 = new BufferedInputStream(stream);){
                    tag = (ListTag)NBTIO.readTag(buffered2, ByteOrder.LITTLE_ENDIAN, false);
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable buffered2) {
                states = buffered2;
                throw buffered2;
            }
            finally {
                if (stream != null) {
                    if (states != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable buffered2) {
                            ((Throwable)states).addSuppressed(buffered2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        for (CompoundTag state : tag.getAll()) {
            void var5_19;
            int runtimeId = runtimeIdAllocator.getAndIncrement();
            List list = (List)metaOverrides.get(state.getCompound("block").copy().remove("version"));
            if (list == null) {
                if (!state.contains("LegacyStates")) continue;
                List<CompoundTag> list2 = state.getList("LegacyStates", CompoundTag.class).getAll();
            }
            String name = state.getCompound("block").getString("name");
            CompoundTag firstState = (CompoundTag)var5_19.get(0);
            int id = firstState.getInt("id");
            runtimeIdToLegacy.put(runtimeId, id << 6 | firstState.getShort("val"));
            stringToLegacyId.put(name, id);
            legacyIdToString.put(id, (Object)name);
            for (CompoundTag legacyState : var5_19) {
                int legacyId = legacyState.getInt("id") << 6 | legacyState.getShort("val");
                legacyToRuntimeId.put(legacyId, runtimeId);
            }
            state.remove("meta");
            state.remove("LegacyStates");
        }
        try {
            BLOCK_PALETTE = NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

