/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.noise.nukkit.d;

import cn.nukkit.level.generator.noise.nukkit.d.NoiseD;
import cn.nukkit.math.NukkitRandom;

public class PerlinD
extends NoiseD {
    public PerlinD(NukkitRandom random, double octaves, double persistence) {
        this(random, octaves, persistence, 1.0);
    }

    public PerlinD(NukkitRandom random, double octaves, double persistence, double expansion) {
        int i;
        this.octaves = octaves;
        this.persistence = persistence;
        this.expansion = expansion;
        this.offsetX = random.nextFloat() * 256.0f;
        this.offsetY = random.nextFloat() * 256.0f;
        this.offsetZ = random.nextFloat() * 256.0f;
        this.perm = new int[512];
        for (i = 0; i < 256; ++i) {
            this.perm[i] = random.nextBoundedInt(256);
        }
        for (i = 0; i < 256; ++i) {
            int pos = random.nextBoundedInt(256 - i) + i;
            int old = this.perm[i];
            this.perm[i] = this.perm[pos];
            this.perm[pos] = old;
            this.perm[i + 256] = this.perm[i];
        }
    }

    @Override
    public double getNoise2D(double x, double y) {
        return this.getNoise3D(x, y, 0.0);
    }

    @Override
    public double getNoise3D(double x, double y, double z) {
        int floorX = (int)(x += this.offsetX);
        int floorY = (int)(y += this.offsetY);
        int floorZ = (int)(z += this.offsetZ);
        int X = floorX & 0xFF;
        int Y = floorY & 0xFF;
        int Z = floorZ & 0xFF;
        double fX = (x -= (double)floorX) * x * x * (x * (x * 6.0 - 15.0) + 10.0);
        double fY = (y -= (double)floorY) * y * y * (y * (y * 6.0 - 15.0) + 10.0);
        double fZ = (z -= (double)floorZ) * z * z * (z * (z * 6.0 - 15.0) + 10.0);
        int A = this.perm[X] + Y;
        int B = this.perm[X + 1] + Y;
        int AA = this.perm[A] + Z;
        int AB = this.perm[A + 1] + Z;
        int BA = this.perm[B] + Z;
        int BB = this.perm[B + 1] + Z;
        double AA1 = PerlinD.grad(this.perm[AA], x, y, z);
        double BA1 = PerlinD.grad(this.perm[BA], x - 1.0, y, z);
        double AB1 = PerlinD.grad(this.perm[AB], x, y - 1.0, z);
        double BB1 = PerlinD.grad(this.perm[BB], x - 1.0, y - 1.0, z);
        double AA2 = PerlinD.grad(this.perm[AA + 1], x, y, z - 1.0);
        double BA2 = PerlinD.grad(this.perm[BA + 1], x - 1.0, y, z - 1.0);
        double AB2 = PerlinD.grad(this.perm[AB + 1], x, y - 1.0, z - 1.0);
        double BB2 = PerlinD.grad(this.perm[BB + 1], x - 1.0, y - 1.0, z - 1.0);
        double xLerp11 = AA1 + fX * (BA1 - AA1);
        double zLerp1 = xLerp11 + fY * (AB1 + fX * (BB1 - AB1) - xLerp11);
        double xLerp21 = AA2 + fX * (BA2 - AA2);
        return zLerp1 + fZ * (xLerp21 + fY * (AB2 + fX * (BB2 - AB2) - xLerp21) - zLerp1);
    }
}

