/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;

public class ObjectSavannaTree
extends TreeGenerator {
    private static final Block TRUNK = Block.get(162, 0);
    private static final Block LEAF = Block.get(161, 0);

    @Override
    public boolean generate(ChunkManager level, NukkitRandom rand, Vector3 position) {
        int i = rand.nextBoundedInt(3) + rand.nextBoundedInt(3) + 5;
        boolean flag = true;
        if (position.getY() >= 1.0 && position.getY() + (double)i + 1.0 <= 256.0) {
            int j = (int)position.getY();
            while ((double)j <= position.getY() + 1.0 + (double)i) {
                int k = 1;
                if ((double)j == position.getY()) {
                    k = 0;
                }
                if ((double)j >= position.getY() + 1.0 + (double)i - 2.0) {
                    k = 2;
                }
                Vector3 vector3 = new Vector3();
                int l = (int)position.getX() - k;
                while ((double)l <= position.getX() + (double)k && flag) {
                    int i1 = (int)position.getZ() - k;
                    while ((double)i1 <= position.getZ() + (double)k && flag) {
                        if (j >= 0 && j < 256) {
                            vector3.setComponents(l, j, i1);
                            if (!this.canGrowInto(level.getBlockIdAt((int)vector3.x, (int)vector3.y, (int)vector3.z))) {
                                flag = false;
                            }
                        } else {
                            flag = false;
                        }
                        ++i1;
                    }
                    ++l;
                }
                ++j;
            }
            if (!flag) {
                return false;
            }
            Vector3 down = position.down();
            int block = level.getBlockIdAt(down.getFloorX(), down.getFloorY(), down.getFloorZ());
            if ((block == 2 || block == 3) && position.getY() < (double)(256 - i - 1)) {
                this.setDirtAt(level, position.down());
                BlockFace face = BlockFace.Plane.HORIZONTAL.random(rand);
                int k2 = i - rand.nextBoundedInt(4) - 1;
                int l2 = 3 - rand.nextBoundedInt(3);
                int i3 = position.getFloorX();
                int j1 = position.getFloorZ();
                int k1 = 0;
                for (int l1 = 0; l1 < i; ++l1) {
                    Vector3 blockpos;
                    int material;
                    int i2 = position.getFloorY() + l1;
                    if (l1 >= k2 && l2 > 0) {
                        i3 += face.getXOffset();
                        j1 += face.getZOffset();
                        --l2;
                    }
                    if ((material = level.getBlockIdAt((blockpos = new Vector3(i3, i2, j1)).getFloorX(), blockpos.getFloorY(), blockpos.getFloorZ())) != 0 && material != 18) continue;
                    this.placeLogAt(level, blockpos);
                    k1 = i2;
                }
                Vector3 blockpos2 = new Vector3(i3, k1, j1);
                for (int j3 = -3; j3 <= 3; ++j3) {
                    for (int i4 = -3; i4 <= 3; ++i4) {
                        if (Math.abs(j3) == 3 && Math.abs(i4) == 3) continue;
                        this.placeLeafAt(level, blockpos2.add(j3, 0.0, i4));
                    }
                }
                blockpos2 = blockpos2.up();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.placeLeafAt(level, blockpos2.add(k3, 0.0, j4));
                    }
                }
                this.placeLeafAt(level, blockpos2.east(2));
                this.placeLeafAt(level, blockpos2.west(2));
                this.placeLeafAt(level, blockpos2.south(2));
                this.placeLeafAt(level, blockpos2.north(2));
                i3 = position.getFloorX();
                j1 = position.getFloorZ();
                BlockFace face1 = BlockFace.Plane.HORIZONTAL.random(rand);
                if (face1 != face) {
                    int l3 = k2 - rand.nextBoundedInt(2) - 1;
                    int k4 = 1 + rand.nextBoundedInt(3);
                    k1 = 0;
                    for (int l4 = l3; l4 < i && k4 > 0; ++l4, --k4) {
                        if (l4 < 1) continue;
                        int j2 = position.getFloorY() + l4;
                        Vector3 blockpos1 = new Vector3(i3 += face1.getXOffset(), j2, j1 += face1.getZOffset());
                        int material1 = level.getBlockIdAt(blockpos1.getFloorX(), blockpos1.getFloorY(), blockpos1.getFloorZ());
                        if (material1 != 0 && material1 != 18) continue;
                        this.placeLogAt(level, blockpos1);
                        k1 = j2;
                    }
                    if (k1 > 0) {
                        Vector3 blockpos3 = new Vector3(i3, k1, j1);
                        for (int i5 = -2; i5 <= 2; ++i5) {
                            for (int k5 = -2; k5 <= 2; ++k5) {
                                if (Math.abs(i5) == 2 && Math.abs(k5) == 2) continue;
                                this.placeLeafAt(level, blockpos3.add(i5, 0.0, k5));
                            }
                        }
                        blockpos3 = blockpos3.up();
                        for (int j5 = -1; j5 <= 1; ++j5) {
                            for (int l5 = -1; l5 <= 1; ++l5) {
                                this.placeLeafAt(level, blockpos3.add(j5, 0.0, l5));
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(ChunkManager worldIn, Vector3 pos) {
        this.setBlockAndNotifyAdequately(worldIn, pos, TRUNK);
    }

    private void placeLeafAt(ChunkManager worldIn, Vector3 pos) {
        int material = worldIn.getBlockIdAt(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
        if (material == 0 || material == 18) {
            this.setBlockAndNotifyAdequately(worldIn, pos, LEAF);
        }
    }
}

