/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.object.tree;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.math.NukkitRandom;

public class ObjectSpruceTree
extends ObjectTree {
    protected int treeHeight;

    @Override
    public int getTrunkBlock() {
        return 17;
    }

    @Override
    public int getLeafBlock() {
        return 18;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getTreeHeight() {
        return this.treeHeight;
    }

    @Override
    public void placeObject(ChunkManager level, int x, int y, int z, NukkitRandom random) {
        this.treeHeight = random.nextBoundedInt(4) + 6;
        int topSize = this.getTreeHeight() - (1 + random.nextBoundedInt(2));
        int lRadius = 2 + random.nextBoundedInt(2);
        this.placeTrunk(level, x, y, z, random, this.getTreeHeight() - random.nextBoundedInt(3));
        this.placeLeaves(level, topSize, lRadius, x, y, z, random);
    }

    public void placeLeaves(ChunkManager level, int topSize, int lRadius, int x, int y, int z, NukkitRandom random) {
        int radius = random.nextBoundedInt(2);
        int maxR = 1;
        int minR = 0;
        for (int yy = 0; yy <= topSize; ++yy) {
            int yyy = y + this.treeHeight - yy;
            for (int xx = x - radius; xx <= x + radius; ++xx) {
                int xOff = Math.abs(xx - x);
                for (int zz = z - radius; zz <= z + radius; ++zz) {
                    int zOff = Math.abs(zz - z);
                    if (xOff == radius && zOff == radius && radius > 0 || Block.solid[level.getBlockIdAt(xx, yyy, zz)]) continue;
                    level.setBlockAt(xx, yyy, zz, this.getLeafBlock(), this.getType());
                }
            }
            if (radius >= maxR) {
                radius = minR;
                minR = 1;
                if (++maxR <= lRadius) continue;
                maxR = lRadius;
                continue;
            }
            ++radius;
        }
    }
}

