/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.inventory.transaction.data.ReleaseItemData;
import cn.nukkit.inventory.transaction.data.TransactionData;
import cn.nukkit.inventory.transaction.data.UseItemData;
import cn.nukkit.inventory.transaction.data.UseItemOnEntityData;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.NetworkInventoryAction;
import java.util.ArrayDeque;
import java.util.Arrays;

public class InventoryTransactionPacket
extends DataPacket {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MISMATCH = 1;
    public static final int TYPE_USE_ITEM = 2;
    public static final int TYPE_USE_ITEM_ON_ENTITY = 3;
    public static final int TYPE_RELEASE_ITEM = 4;
    public static final int USE_ITEM_ACTION_CLICK_BLOCK = 0;
    public static final int USE_ITEM_ACTION_CLICK_AIR = 1;
    public static final int USE_ITEM_ACTION_BREAK_BLOCK = 2;
    public static final int RELEASE_ITEM_ACTION_RELEASE = 0;
    public static final int RELEASE_ITEM_ACTION_CONSUME = 1;
    public static final int USE_ITEM_ON_ENTITY_ACTION_INTERACT = 0;
    public static final int USE_ITEM_ON_ENTITY_ACTION_ATTACK = 1;
    public static final int ACTION_MAGIC_SLOT_DROP_ITEM = 0;
    public static final int ACTION_MAGIC_SLOT_PICKUP_ITEM = 1;
    public static final int ACTION_MAGIC_SLOT_CREATIVE_DELETE_ITEM = 0;
    public static final int ACTION_MAGIC_SLOT_CREATIVE_CREATE_ITEM = 1;
    public int transactionType;
    public NetworkInventoryAction[] actions;
    public TransactionData transactionData;
    public boolean isCraftingPart = false;

    @Override
    public byte pid() {
        return 30;
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.transactionType);
        this.putUnsignedVarInt(this.actions.length);
        for (NetworkInventoryAction action : this.actions) {
            action.write(this);
        }
        switch (this.transactionType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                UseItemData useItemData = (UseItemData)this.transactionData;
                this.putUnsignedVarInt(useItemData.actionType);
                this.putBlockVector3(useItemData.blockPos);
                this.putBlockFace(useItemData.face);
                this.putVarInt(useItemData.hotbarSlot);
                this.putSlot(useItemData.itemInHand);
                this.putVector3f(useItemData.playerPos.asVector3f());
                this.putVector3f(useItemData.clickPos);
                this.putUnsignedVarInt(useItemData.blockRuntimeId);
                break;
            }
            case 3: {
                UseItemOnEntityData useItemOnEntityData = (UseItemOnEntityData)this.transactionData;
                this.putEntityRuntimeId(useItemOnEntityData.entityRuntimeId);
                this.putUnsignedVarInt(useItemOnEntityData.actionType);
                this.putVarInt(useItemOnEntityData.hotbarSlot);
                this.putSlot(useItemOnEntityData.itemInHand);
                this.putVector3f(useItemOnEntityData.playerPos.asVector3f());
                this.putVector3f(useItemOnEntityData.clickPos.asVector3f());
                break;
            }
            case 4: {
                ReleaseItemData releaseItemData = (ReleaseItemData)this.transactionData;
                this.putUnsignedVarInt(releaseItemData.actionType);
                this.putVarInt(releaseItemData.hotbarSlot);
                this.putSlot(releaseItemData.itemInHand);
                this.putVector3f(releaseItemData.headRot.asVector3f());
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction type " + this.transactionType);
            }
        }
    }

    @Override
    public void decode() {
        this.transactionType = (int)this.getUnsignedVarInt();
        int length = (int)this.getUnsignedVarInt();
        ArrayDeque<NetworkInventoryAction> actions = new ArrayDeque<NetworkInventoryAction>();
        for (int i = 0; i < length; ++i) {
            actions.add(new NetworkInventoryAction().read(this));
        }
        this.actions = actions.toArray(new NetworkInventoryAction[0]);
        switch (this.transactionType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                UseItemData itemData = new UseItemData();
                itemData.actionType = (int)this.getUnsignedVarInt();
                itemData.blockPos = this.getBlockVector3();
                itemData.face = this.getBlockFace();
                itemData.hotbarSlot = this.getVarInt();
                itemData.itemInHand = this.getSlot();
                itemData.playerPos = this.getVector3f().asVector3();
                itemData.clickPos = this.getVector3f();
                itemData.blockRuntimeId = (int)this.getUnsignedVarInt();
                this.transactionData = itemData;
                break;
            }
            case 3: {
                UseItemOnEntityData useItemOnEntityData = new UseItemOnEntityData();
                useItemOnEntityData.entityRuntimeId = this.getEntityRuntimeId();
                useItemOnEntityData.actionType = (int)this.getUnsignedVarInt();
                useItemOnEntityData.hotbarSlot = this.getVarInt();
                useItemOnEntityData.itemInHand = this.getSlot();
                useItemOnEntityData.playerPos = this.getVector3f().asVector3();
                useItemOnEntityData.clickPos = this.getVector3f().asVector3();
                this.transactionData = useItemOnEntityData;
                break;
            }
            case 4: {
                ReleaseItemData releaseItemData = new ReleaseItemData();
                releaseItemData.actionType = (int)this.getUnsignedVarInt();
                releaseItemData.hotbarSlot = this.getVarInt();
                releaseItemData.itemInHand = this.getSlot();
                releaseItemData.headRot = this.getVector3f().asVector3();
                this.transactionData = releaseItemData;
                break;
            }
            default: {
                throw new RuntimeException("Unknown transaction type " + this.transactionType);
            }
        }
    }

    public String toString() {
        return "InventoryTransactionPacket(transactionType=" + this.transactionType + ", actions=" + Arrays.deepToString(this.actions) + ", transactionData=" + this.transactionData + ", isCraftingPart=" + this.isCraftingPart + ")";
    }
}

