/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin.service;

import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.service.RegisteredServiceProvider;
import cn.nukkit.plugin.service.ServiceManager;
import cn.nukkit.plugin.service.ServicePriority;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NKServiceManager
implements ServiceManager {
    private final Map<Class<?>, List<RegisteredServiceProvider<?>>> handle = new HashMap();

    @Override
    public <T> boolean register(Class<T> service, T provider, Plugin plugin, ServicePriority priority) {
        Preconditions.checkNotNull(provider);
        Preconditions.checkNotNull((Object)((Object)priority));
        Preconditions.checkNotNull(service);
        if (plugin == null && provider.getClass().getClassLoader() != Server.class.getClassLoader()) {
            throw new NullPointerException("plugin");
        }
        return this.provide(service, provider, plugin, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> boolean provide(Class<T> service, T instance, Plugin plugin, ServicePriority priority) {
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            List list = this.handle.computeIfAbsent(service, k -> new ArrayList());
            RegisteredServiceProvider<T> registered = new RegisteredServiceProvider<T>(service, instance, priority, plugin);
            int position = Collections.binarySearch(list, registered);
            if (position > -1) {
                return false;
            }
            list.add(-(position + 1), registered);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RegisteredServiceProvider<?>> cancel(Plugin plugin) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            for (List<RegisteredServiceProvider<?>> list : this.handle.values()) {
                Iterator<RegisteredServiceProvider<?>> it = list.iterator();
                while (it.hasNext()) {
                    RegisteredServiceProvider<?> registered = it.next();
                    if (registered.getPlugin() != plugin) continue;
                    it.remove();
                    builder.add(registered);
                }
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> RegisteredServiceProvider<T> cancel(Class<T> service, T provider) {
        RegisteredServiceProvider<?> result = null;
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            Iterator<RegisteredServiceProvider<?>> it = this.handle.get(service).iterator();
            while (it.hasNext() && result == null) {
                RegisteredServiceProvider<?> next = it.next();
                if (next.getProvider() != provider) continue;
                it.remove();
                result = next;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> RegisteredServiceProvider<T> getProvider(Class<T> service) {
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            List<RegisteredServiceProvider<?>> list = this.handle.get(service);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }

    @Override
    public List<Class<?>> getKnownService() {
        return ImmutableList.copyOf(this.handle.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RegisteredServiceProvider<?>> getRegistrations(Plugin plugin) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            for (List<RegisteredServiceProvider<?>> registered : this.handle.values()) {
                for (RegisteredServiceProvider<?> provider : registered) {
                    if (!provider.getPlugin().equals(plugin)) continue;
                    builder.add(provider);
                }
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<RegisteredServiceProvider<T>> getRegistrations(Class<T> service) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            List<RegisteredServiceProvider<?>> registered = this.handle.get(service);
            if (registered == null) {
                ImmutableList empty = ImmutableList.of();
                return empty;
            }
            for (RegisteredServiceProvider<?> provider : registered) {
                builder.add(provider);
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean isProvidedFor(Class<T> service) {
        Map<Class<?>, List<RegisteredServiceProvider<?>>> map = this.handle;
        synchronized (map) {
            return this.handle.containsKey(service);
        }
    }
}

