/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.network.protocol.AdventureSettingsPacket;
import cn.nukkit.network.protocol.DataPacket;
import java.util.EnumMap;
import java.util.Map;

public class AdventureSettings
implements Cloneable {
    public static final int PERMISSION_NORMAL = 0;
    public static final int PERMISSION_OPERATOR = 1;
    public static final int PERMISSION_HOST = 2;
    public static final int PERMISSION_AUTOMATION = 3;
    public static final int PERMISSION_ADMIN = 4;
    private Map<Type, Boolean> values = new EnumMap<Type, Boolean>(Type.class);
    private Player player;

    public AdventureSettings(Player player) {
        this.player = player;
    }

    public AdventureSettings clone(Player newPlayer) {
        try {
            AdventureSettings settings = (AdventureSettings)super.clone();
            settings.player = newPlayer;
            return settings;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AdventureSettings set(Type type, boolean value) {
        this.values.put(type, value);
        return this;
    }

    public boolean get(Type type) {
        Boolean value = this.values.get((Object)type);
        return value == null ? type.getDefaultValue() : value.booleanValue();
    }

    public void update() {
        AdventureSettingsPacket pk = new AdventureSettingsPacket();
        for (Type t : Type.values()) {
            pk.setFlag(t.getId(), this.get(t));
        }
        pk.commandPermission = this.player.isOp() ? 1 : 0;
        pk.playerPermission = this.player.isOp() ? 2 : 1;
        pk.entityUniqueId = this.player.getId();
        Server.broadcastPacket(this.player.getViewers().values(), (DataPacket)pk);
        this.player.dataPacket(pk);
        this.player.resetInAirTicks();
    }

    public static enum Type {
        WORLD_IMMUTABLE(1, false),
        AUTO_JUMP(32, true),
        ALLOW_FLIGHT(64, false),
        NO_CLIP(128, false),
        WORLD_BUILDER(256, true),
        FLYING(512, false),
        MUTED(1024, false),
        BUILD_AND_MINE(65537, true),
        DOORS_AND_SWITCHED(65538, true),
        OPEN_CONTAINERS(65540, true),
        ATTACK_PLAYERS(65544, true),
        ATTACK_MOBS(65552, true),
        OPERATOR(65568, false),
        TELEPORT(65664, false);

        private final int id;
        private final boolean defaultValue;

        private Type(int id, boolean defaultValue) {
            this.id = id;
            this.defaultValue = defaultValue;
        }

        public int getId() {
            return this.id;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }
    }
}

