/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemDye;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCocoa
extends BlockTransparentMeta
implements Faceable {
    protected static final AxisAlignedBB[] EAST = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.6875, 0.4375, 0.375, 0.9375, 0.75, 0.625), new SimpleAxisAlignedBB(0.5625, 0.3125, 0.3125, 0.9375, 0.75, 0.6875), new SimpleAxisAlignedBB(0.5625, 0.3125, 0.3125, 0.9375, 0.75, 0.6875)};
    protected static final AxisAlignedBB[] WEST = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.0625, 0.4375, 0.375, 0.3125, 0.75, 0.625), new SimpleAxisAlignedBB(0.0625, 0.3125, 0.3125, 0.4375, 0.75, 0.6875), new SimpleAxisAlignedBB(0.0625, 0.3125, 0.3125, 0.4375, 0.75, 0.6875)};
    protected static final AxisAlignedBB[] NORTH = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.375, 0.4375, 0.0625, 0.625, 0.75, 0.3125), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.0625, 0.6875, 0.75, 0.4375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.0625, 0.6875, 0.75, 0.4375)};
    protected static final AxisAlignedBB[] SOUTH = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.375, 0.4375, 0.6875, 0.625, 0.75, 0.9375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.75, 0.9375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.75, 0.9375)};
    protected static final AxisAlignedBB[] ALL = new AxisAlignedBB[12];

    public BlockCocoa() {
        this(0);
    }

    public BlockCocoa(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 127;
    }

    @Override
    public String getName() {
        return "Cocoa";
    }

    @Override
    public void setDamage(int meta) {
        super.setDamage(meta);
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    private AxisAlignedBB getRelativeBoundingBox() {
        AxisAlignedBB[] bbs;
        AxisAlignedBB boundingBox;
        int damage = this.getDamage();
        if (damage > 11) {
            damage = 11;
            this.setDamage(11);
        }
        if ((boundingBox = ALL[damage]) != null) {
            return boundingBox;
        }
        switch (this.getDamage()) {
            case 0: 
            case 4: 
            case 8: {
                bbs = NORTH;
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                bbs = EAST;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                bbs = SOUTH;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                bbs = WEST;
                break;
            }
            default: {
                bbs = NORTH;
            }
        }
        BlockCocoa.ALL[damage] = bbs[this.getDamage() >> 2];
        return BlockCocoa.ALL[damage];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.getId() == 17 && (target.getDamage() & 3) == 3 && face != BlockFace.DOWN && face != BlockFace.UP) {
            int[] faces = new int[]{0, 0, 0, 2, 3, 1};
            this.setDamage(faces[face.getIndex()]);
            this.level.setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            int[] faces = new int[]{3, 4, 2, 5, 3, 4, 2, 5, 3, 4, 2, 5};
            Block side = this.getSide(BlockFace.fromIndex(faces[this.getDamage()]));
            if (side.getId() == 17 || side.getDamage() == 3) return 0;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 0;
        if (ThreadLocalRandom.current().nextInt(2) != 1) return 2;
        if (this.getDamage() / 4 >= 2) return 0;
        BlockCocoa block = (BlockCocoa)this.clone();
        block.setDamage(block.getDamage() + 4);
        BlockGrowEvent ev = new BlockGrowEvent(this, block);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) return 2;
        this.getLevel().setBlock((Vector3)this, ev.getNewState(), true, true);
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.getId() == 351 && item.getDamage() == 15) {
            Block block = this.clone();
            if (this.getDamage() / 4 < 2) {
                block.setDamage(block.getDamage() + 4);
                BlockGrowEvent ev = new BlockGrowEvent(this, block);
                Server.getInstance().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                this.getLevel().setBlock((Vector3)this, ev.getNewState(), true, true);
                this.level.addParticle(new BoneMealParticle(this));
                if (player != null && (player.gamemode & 1) == 0) {
                    --item.count;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemDye((Integer)DyeColor.BROWN.getDyeData());
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.getDamage() >= 8) {
            return new Item[]{new ItemDye((Integer)3, 3)};
        }
        return new Item[]{new ItemDye((Integer)3, 1)};
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

